<?php

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

/**
 * Available Variables:
 * 
 * $certificate = array(
 *      post                : Object (WP_Post)          Certificate post.
 *      csuid               : String                    Unique Certificate ID.
 *      title               : String                    Certificate title.
 *      description         : String                    Certificate description.
 *      pdf_meta            : Array                     Certificate pdf meta. Contains info about the PDF format and orientation.
 *      type                : String                    Certificate type. Can be course, quiz or group.
 *      source              : Object (WP_Post)          Can be Course, Quiz or Group post.
 *      course              : Object|Array (WP_Post)    Certificate course post. WP_Post of a Course or an array of WP_Post of Group Courses.
 *      issue_date          : String                    Certificate issue course.
 *      instructor          : Object (WP_User)          The certificate provider user object which is currently only the site admin.
 *      recipient           : Object (WP_User)          The certificate earner user object.
 *      pdf_view_url        : String                    URL to view a PDF.
 *      pdf_download_url    : String                    URL to download a PDF.
 * );
 * 
 * $social_buttons                      : String        HTML content of the social sharing buttons.
 * $ld_pay_for_quiz_certificate         : Null|Array    Data of the LearnDash Pay for Quiz & Certificate plugin.
 * 
 * @since 1.0.8
 */
?>

<div class="ld-cvss-container">
    <div class="ld-cvss-certificate">
        <div class="ld-cvss-col-1">
            <div class="ld-cvss-certificate-id"><?php _e( 'ID', 'LD-CVSS' ); ?>: <?php echo $certificate['csuid']; ?></div>
            <noscript><?php _e( 'Javascript must be enabled in the browser to see the certificate.', 'LD-CVSS' ); ?> <a href="https://www.enable-javascript.com/" target="_blank" rel="noopener noreferrer nofollow"><?php _e( 'See how to do it', 'LD-CVSS' ); ?></a>.</noscript>
            <div id="ld-cvss-certificate-img" class="ld-cvss-certificate-img ld-cvss-certificate-loading ld-cvss-certificate-format-<?php echo esc_attr( strtolower( $certificate['pdf_meta']['pdf_page_format'] ) ); ?> ld-cvss-certificate-orientation-<?php echo esc_attr( strtolower( $certificate['pdf_meta']['pdf_page_orientation'] ) ); ?>">
                <canvas id="ld-cvss-pdf2image-canvas"></canvas>
            </div>
            <div class="ld-cvss-course-verification-meta">
                <div class="ld-cvss-verification-title"><?php echo $certificate['title']; ?></div>
                <?php if ( ! empty( $certificate['description'] ) ) : ?>
                    <div class="ld-cvss-verification-desc"><?php echo $certificate['description']; ?></div>
                <?php endif; ?>
            </div>
        </div>
        <div class="ld-cvss-col-2">
            <div class="ld-cvss-certificate-user-data">
                <div class="ld-cvss-certificate-user ld-cvss-certificate-user-recipient">
                    <div class="ld-cvss-certificate-user-thumb">
                        <img src="<?php echo esc_url( get_avatar_url( $certificate['recipient']->ID ) ); ?>" alt="<?php echo esc_attr( apply_filters( 'ld_cvss_verfication_page_recipient_display_name', $certificate['recipient']->display_name, $certificate['recipient'] ) ); ?>">
                    </div>
                    <div class="ld-cvss-certificate-user-meta ld-cvss-certificate-user-meta-recipient">
                        <div class="ld-cvss-certificate-user-designation"><?php _e( 'recipient', 'LD-CVSS' ); ?></div>
                        <div class="ld-cvss-certificate-user-name"><?php echo apply_filters( 'ld_cvss_verfication_page_recipient_display_name', $certificate['recipient']->display_name, $certificate['recipient'] ); ?></div>
                    </div>
                </div>
                <?php if ( apply_filters('ld_cvss_certificate_verification_page_show_instructor', true, $certificate, $certificate['post'], $certificate['recipient'], $certificate['instructor'] ) ): ?>
                    <div class="ld-cvss-certificate-user ld-cvss-certificate-user-instructor">
                        <div class="ld-cvss-certificate-user-thumb">
                            <img src="<?php echo esc_url( get_avatar_url( $certificate['instructor']->ID ) ); ?>" alt="<?php echo esc_attr( apply_filters( 'ld_cvss_verfication_page_instructor_display_name', $certificate['instructor']->display_name, $certificate['instructor'] ) ); ?>">
                        </div>
                        <div class="ld-cvss-certificate-user-meta ld-cvss-certificate-user-meta-instructor">
                            <div class="ld-cvss-certificate-user-designation"><?php _e( 'instructor', 'LD-CVSS' ); ?></div>
                            <div class="ld-cvss-certificate-user-name"><?php echo apply_filters( 'ld_cvss_verfication_page_instructor_display_name', $certificate['instructor']->display_name, $certificate['instructor'] ); ?></div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <?php if ( in_array( $certificate['type'], array( 'course', 'quiz' ) ) ): ?>
                <div class="ld-cvss-course-info">
                    <div class="ld-cvss-course-info-title"><?php _e( 'About The Course', 'LD-CVSS' ); ?></div>
                    <div class="ld-cvss-course-card">
                        <?php if ( has_post_thumbnail( $certificate['course']->ID ) ): ?>
                            <div class="ld-cvss-course-card-thumb">
                                <?php echo get_the_post_thumbnail( $certificate['course']->ID, 'large', array( 'alt' => $certificate['course']->post_title ) ); ?>
                            </div>
                        <?php endif; ?>
                        <div class="ld-cvss-course-card-info">
                            <div class="ld-cvss-course-card-title"><?php echo $certificate['course']->post_title; ?></div>
                            <div class="ld-cvss-course-card-read-more">
                                <?php 
                                if ( has_filter( 'ld_cvs_verfication_page_course_read_more_url' ) ) {
                                    $course_permalink = apply_filters_deprecated( 'ld_cvs_verfication_page_course_read_more_url', array( get_the_permalink( $certificate['course']->ID ), $certificate['course']->ID, $certificate['type'] .'-certificate' ), '1.0.7', 'ld_cvss_verfication_page_course_read_more_url' );
                                }

                                $course_permalink = apply_filters( 'ld_cvss_verfication_page_course_read_more_url', get_the_permalink( $certificate['course']->ID ), $certificate['course']->ID, $certificate['type'] .'-certificate', $certificate['post'], $certificate['source'], $certificate['recipient'], $certificate['instructor'] ); 
                                ?>
                                <a href="<?php echo esc_url( $course_permalink ); ?>" class="ld-cvss-course-card-read-more-link" target="_blank"><?php _e( 'read more', 'LD-CVSS' ); ?><span class="ld-cvss-course-card-read-more-arrow"></span></a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php if ( $certificate['type'] == 'group' ) : ?>
                <div class="ld-cvss-course-info">
                <div class="ld-cvss-course-info-title"><?php _e( 'About The Group\'s Courses', 'LD-CVSS' ); ?></div>
                    <?php foreach( $certificate['course'] as $course ): ?>
                        <div class="ld-cvss-course-card">
                            <?php if ( has_post_thumbnail( $course->ID ) ): ?>
                                <div class="ld-cvss-course-card-thumb">
                                    <?php echo get_the_post_thumbnail( $course->ID, 'large', array( 'alt' => $course->post_title ) ); ?>
                                </div>
                            <?php endif; ?>
                            <div class="ld-cvss-course-card-info">
                                <div class="ld-cvss-course-card-title"><?php echo $course->post_title; ?></div>
                                <div class="ld-cvss-course-card-read-more">
                                    <?php 
                                    if ( has_filter( 'ld_cvs_verfication_page_course_read_more_url' ) ) {
                                        $course_permalink = apply_filters_deprecated( 'ld_cvs_verfication_page_course_read_more_url', array( get_the_permalink( $course->ID ), $course->ID, $certificate['type'] .'-certificate' ), '1.0.7', 'ld_cvss_verfication_page_course_read_more_url' );
                                    }

                                    $course_permalink = apply_filters( 'ld_cvss_verfication_page_course_read_more_url', get_the_permalink( $course->ID ), $course->ID, $certificate['type'] .'-certificate', $certificate['post'], $certificate['source'], $certificate['recipient'], $certificate['instructor'] ); 
                                    ?>
                                    <a href="<?php echo esc_url( $course_permalink ); ?>" class="ld-cvss-course-card-read-more-link" target="_blank"><?php _e( 'read more', 'LD-CVSS' ); ?><span class="ld-cvss-course-card-read-more-arrow"></span></a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
            <?php echo $social_buttons; ?>
            <?php if ( $ld_pay_for_quiz_certificate['is_owner'] || $ld_pay_for_quiz_certificate['is_viewable'] ) : ?>
                <div class="ld-cvss-download-cert">
                    <?php if ( $ld_pay_for_quiz_certificate['is_purchased'] ) : ?>
                        <a id="ld-cvss-download-certificate-pdf" href="<?php echo esc_url( $certificate['pdf_download_url'] ); ?>"><?php _e( 'Download PDF', 'LD-CVSS' ); ?></a>
                    <?php elseif ( $ld_pay_for_quiz_certificate['is_owner'] ): 
                        echo $ld_pay_for_quiz_certificate['purchase_button'];
                    endif; ?>
                </div>
            <?php endif; ?>
            <div class="ld-cvss-course-issue-date">
                <span class="ld-cvss-course-issue-date-title"><?php _e( 'Issue Date', 'LD-CVSS' ); ?>:</span> <span class="ld-cvss-course-issue-date-date"><?php echo $certificate['issue_date']; ?></span>
            </div>
        </div>
    </div>
</div>