<?php

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

/**
 * Available Variables:
 * 
 * $social_networks     : Array of social networks.
 * $iframe              : Iframe for generation images from PDF.
 * 
 * @since 1.0.8
 */

if ( ! $social_networks ) {
    return '';
}
?>

<div class="ld-cvss-social-buttons">
    <ul class="ld-cvss-social-buttons-list">
        <?php foreach( $social_networks as $social_network_id => $social_network ) : 
            $button_id_to_class     = str_replace( '_', '-', $social_network_id );
            $button_link_classes    = array( 'ld-cvss-social-button-link', 'ld-cvss-social-button-link-' . $button_id_to_class );
            $popup_width            = 600;
            $popup_height           = 600;
            $attr_on_click          = sprintf( 
                'window.open(\'%1$s\', \'%2$s\', \'width=%3$s,height=%4$s,left=0,top=0,location=1,scrollbars=1,status=1,resizable=1,toolbar=0,menubar=0\');return false;',
                $social_network['url'],
                sprintf( __( 'Share on %s', 'LD-CVSS' ), $social_network['title'] ),
                $popup_width,
                $popup_height
            );


            if ( $social_network['title'] ) {
                $button_link_classes[] = 'ld-cvss-social-button-link-tooltip';
            }

//            if ( $social_network_id == 'linkedin_profile' ) {
//                $button_link_classes[] = 'ld-button ld-cvss-button ld-cvss-button-' . $button_id_to_class;
//
//                $button_content = sprintf(
//                    '<i class="ld-cvss-button-icon fa fa-linkedin"></i>%s',
//                    __( 'Add to Profile', 'LD-CVSS' )
//                );
//            } else {
//                $button_content = sprintf( '<i class="ld-cvss-social-button-icon fa fa-%s"></i>', $social_network_id );
//            }


            if ( $social_network_id == 'linkedin_profile' ) {
                $button_link_classes[] = 'ld-button ld-cvss-button ld-cvss-button-' . $button_id_to_class;

                $button_content = sprintf(
                    '<i class="ld-cvss-social-button-icon %1s"></i>%2s',
	                $button_id_to_class,
                    __( 'Add to Profile', 'LD-CVSS' )
                );
            } else {
	            $button_content = sprintf( '<i class="ld-cvss-social-button-icon %s"></i>', $button_id_to_class );
            }

//	        $button_content = sprintf( '<i class="ld-cvss-social-button-icon %s"></i>', $button_id_to_class );

            ?>
            <li class="ld-cvss-social-button ld-cvss-social-button-<?php echo esc_attr( $button_id_to_class ); ?>">
                <a href="<?php echo $social_network['url']; ?>" class="<?php echo esc_attr( implode( ' ', $button_link_classes ) ); ?>" target="_blank" onclick="<?php echo $attr_on_click; ?>" rel="noopener noreferrer nofollow" data-title="<?php echo esc_attr( $social_network['title'] ); ?>"><?php echo $button_content; ?></a>
            </li>
        <?php endforeach; ?>
    </ul>
    <?php echo $iframe; ?>
</div>