<?php

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

/**
 * @since 1.0.8
 */
?>

<div class="ld-cvss-container">
    <form id="ld-cvss-search-form" class="ld-cvss-search-form" method="post" action="<?php echo home_url( add_query_arg( false, false ) ); ?>">
        <?php if ( apply_filters( 'ld_cvss_show_search_form_heading', true ) ) : ?>
            <div class="ld-cvss-search-form-heading"><?php echo apply_filters( 'ld_cvss_search_form_heading', __( 'Search Certificate by ID', 'LD-CVSS' ) ); ?></div>
        <?php endif; ?>
        <div class="ld-cvss-search-form-controls">
            <div class="ld-cvss-search-form-control ld-cvss-search-form-control-input">
                <input class="ld-cvss-search-form-input" type="text" autocomplete="off" placeholder="<?php _e( 'Certificate ID', 'LD-CVSS' ); ?>" required>
            </div>
            <div class="ld-cvss-search-form-control ld-cvss-search-form-control-button">
                <button class="ld-cvss-search-form-button" type="submit"><?php _e( 'Search', 'LD-CVSS' ); ?></button>
            </div>
        </div>
    </form>
</div>