<?php

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

/**
 * Available Variables:
 * 
 * $certificate = array(
 *      title               : String                Certificate title.
 *      type                : String                Certificate meta. Can be course, quiz or group.
 *      issue_date          : String                Certificate issue course.
 *      recipient           : Object (WP_User)      The certificate earner user object.
 *      public_url          : String                URL to view the Certificate.
 * );
 * 
 * @since 1.0.8
 */
?>
<div class="ld-cvss-search-form-results">
    <div class="ld-cvss-search-form-results-heading"><?php _e( 'Search Results', 'LD-CVSS' ); ?></div>
    <?php if ( $certificate ) : ?>
        <table class="ld-cvss-search-form-table">
            <thead class="ld-cvss-search-form-table-head">
                <tr class="ld-cvss-search-form-table-row">
                    <td class="ld-cvss-search-form-table-cell ld-cvss-search-form-table-cell-recipient"><?php _e( 'User Name', 'LD-CVSS' ); ?></td>
                    <td class="ld-cvss-search-form-table-cell ld-cvss-search-form-table-cell-title"><?php _e( 'Course, Quiz or Group Title', 'LD-CVSS' ); ?></td>
                    <td class="ld-cvss-search-form-table-cell ld-cvss-search-form-table-cell-type"><?php _e( 'Certificate Type', 'LD-CVSS' ); ?></td>
                    <td class="ld-cvss-search-form-table-cell ld-cvss-search-form-table-cell-date"><?php _e( 'Issue Date', 'LD-CVSS' ); ?></td>
                </tr>
            </thead>
            <tbody class="ld-cvss-search-form-table-body">
                <tr class="ld-cvss-search-form-table-row">
                    <td class="ld-cvss-search-form-table-cell ld-cvss-search-form-table-cell-recipient" data-title="<?php _e( 'User Name', 'LD-CVSS' ); ?>:"><?php echo apply_filters( 'ld_cvss_search_result_page_recipient_display_name', $certificate['recipient']->display_name, $certificate['recipient'] ); ?></td>
                    <td class="ld-cvss-search-form-table-cell ld-cvss-search-form-table-cell-title" data-title="<?php _e( 'Course, Quiz or Group Title', 'LD-CVSS' ); ?>:"><?php echo $certificate['title']; ?></td>
                    <td class="ld-cvss-search-form-table-cell ld-cvss-search-form-table-cell-type" data-title="<?php _e( 'Certificate Type', 'LD-CVSS' ); ?>:"><?php printf( '%s %s', $certificate['type'], __( 'Certificate', 'LD-CVSS' ) ); ?></td>
                    <td class="ld-cvss-search-form-table-cell ld-cvss-search-form-table-cell-date" data-title="<?php _e( 'Issue Date', 'LD-CVSS' ); ?>:"><?php echo $certificate['date']; ?></td>
                </tr>
            </tbody>
        </table>
        <a href="<?php echo $certificate['public_url']; ?>" class="ld-cvss-search-form-verify"><?php _e( 'Verify Certificate', 'LD-CVSS' ); ?></a>
    <?php else : ?>
        <div class="ld-cvss-search-form-error"><?php _e( 'Sorry! Nothing found. Certificate doesn’t exsist or it\'s ID is incorrect.', 'LD-CVSS' ) ?></div>
    <?php endif; ?>
</div>