<?php

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

/**
 * Available Variables:
 * 
 * $notice_manager            Object    Notice Manager.
 * $options                   Object    Options.
 * $page_url                  String    Settings page URL.
 * $active_tab                String    Settings active tab.
 * $current_page_url          String    Current settings page URL including active tab.
 * $tabs                      Array     Settings tabs.
 * $shortcodes                Array     Plugin shortcodes.
 * $pages                     Array     Existing WP pages.
 * $page_templates            Array     Page templates.
 * $is_license_activated      Bool      Plugin activation.
 * $form_actions              Array     Settings form actions.
 * $nonce_field               String    Nonce field.
 * 
 * @since 1.0.8
 */
?>
<div class="wrap ld_cvss-wrap">
<h2 class="ld-cvss-heading"><?php echo get_admin_page_title(); ?></h2>
    <div class="ld-cvss-notices">
        <?php 
            if ( $notice_manager->error->has_notices() ) {
                echo $notice_manager->error->get_all_html();
            } else {
                echo $notice_manager->success->get_all_html(); 
            }
        ?>
    </div>
    <nav class="nav-tab-wrapper ld_cvss-nav-tab-wrapper">
        <?php foreach( $tabs as $tab_id => $tab ) : ?>
            <a href="<?php echo esc_url( $tab['url'] ); ?>" class="nav-tab<?php echo $tab_id == $active_tab ? ' nav-tab-active' : ''; ?>"><?php echo $tab['title']; ?></a>
        <?php endforeach; ?>
    </nav>
    <ul class="subsubsub" style="float:right;margin:15px 0;">
        
    </ul>
    <div class="clear"></div>
    <form method="post" action="<?php echo esc_url( $current_page_url ); ?>">
        <?php if ( $active_tab == 'general' ) : ?>
            <div class="ld-cvss-shortcode-notice" style="margin: 0 0 40px;padding:1px 12px;border:1px solid #c3c4c7;background:#ffffff;box-shadow:0 1px 1px rgba(0,0,0,.04);">
                <p style="margin-bottom:30px;"><?php printf( __( 'Insert the shortcode %s on any page on which you want to display the certificate verification page.', 'LD-CVSS' ), sprintf( '<code style="font-weight:600;">[%s]</code>', $shortcodes['verification_page'] ) ); ?></p>
                <p><?php printf( __( 'You can use the shortcode %s inside certificates to display its certificate ID.', 'LD-CVSS' ), sprintf( '<code style="font-weight:600;">[%s]</code>', $shortcodes['certificate_id'] ) ); ?></p>
                <p><?php printf( __( 'You can use the shortcode %s inside certificates to add QR Code.', 'LD-CVSS' ), sprintf( '<code style="font-weight:600;">[%s]</code>', $shortcodes['certificate_qr_code'] ) ); ?> <a href="#" onclick="document.getElementById('ld-cvss-shortcode-<?php echo $shortcodes['certificate_qr_code']; ?>').classList.toggle('hidden');return false;"><?php _e( 'Available attributes', 'LD-CVSS' ); ?></a></p>
                <table id="ld-cvss-shortcode-<?php echo $shortcodes['certificate_qr_code']; ?>" class="hidden" style="margin:1em 0;">
                    <tbody>
                        <tr>
                            <td><strong>size="100"</strong></td>
                            <td style="padding-left:10px;"><?php _e( 'Size in px. Default: 100.', 'LD-CVSS' ); ?></td>
                        </tr>
                        <tr>
                            <td><strong>inline="true|false"</strong></td>
                            <td style="padding-left:10px;"><?php _e( 'Display as inline or block. Default: true.', 'LD-CVSS' ); ?></td>
                        </tr>
                        <tr>
                            <td><strong>align="left|center|right"</strong></td>
                            <td style="padding-left:10px;"><?php printf( __( 'QR Code alignment. Available only for %s. Default: left.', 'LD-CVSS' ), 'inline="false"' ); ?></td>
                        </tr>
                        <tr>
                            <td><strong>url="https://Your URL"</strong></td>
                            <td style="padding-left:10px;"><?php _e( 'URL to be encoded. Default: Certificate URL.', 'LD-CVSS' ); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <table class="form-table">
                <tbody>
                    <tr valign="top">
                        <th scope="row"><?php _e( 'Verification page', 'LD-CVSS' ); ?></th>
                        <td>
                            <select class="regular-text" name="ld_cvss_settings[verification_page_id]">
                                <option value="0" <?php selected( 0, $options->get( 'verification_page_id' ) ); ?>><?php _e( 'Select...', 'LD-CVSS' ); ?></option>
                                <?php foreach( $pages as $page_id => $page_title ) : ?>
                                    <option value="<?php echo esc_attr( $page_id ); ?>" <?php selected( $page_id, $options->get( 'verification_page_id' ) ); ?>><?php echo $page_title; ?></option>
                                <?php endforeach; ?>
                            </select>
                            <p class="description" style="margin: 20px 0 0;font-style:italic;"><?php printf( __( 'Select the page where the shortcode %s is inserted.', 'LD-CVSS' ), sprintf( '<code style="color:#000000;">[%s]</code>', $shortcodes['verification_page'] ) ); ?></p>
                        </td>
                    </tr>
                    <tr valign="top">
                        <th scope="row"><?php _e( 'Verification page template', 'LD-CVSS' ); ?></th>
                        <td>
                            <select class="regular-text" name="ld_cvss_settings[verification_page_template]">
                                <?php foreach( $page_templates as $page_template_id => $page_template_title ) : ?>
                                    <option value="<?php echo esc_attr( $page_template_id ); ?>" <?php selected( $page_template_id, $options->get( 'verification_page_template' ) ); ?>><?php echo $page_template_title; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </td>
                    </tr>
                    <tr valign="top">
                        <th scope="row"><?php _e( 'Certificate issue date format', 'LD-CVSS' ); ?></th>
                        <td>
                            <input class="regular-text" type="text" name="ld_cvss_settings[certificate_issue_date_format]" value="<?php echo esc_attr( $options->get( 'certificate_issue_date_format' ) ); ?>">
                            <p class="description" style="margin: 20px 0 0;font-style:italic;"><?php printf( '<a href="https://wordpress.org/support/article/formatting-date-and-time/" target="_blank">%s</a>.', __( 'Documentation on date and time formatting', 'LD-CVSS' ) ); ?></p>
                        </td>
                    </tr>
                    <tr valign="top">
                        <th scope="row"><?php _e( 'Image social sharing', 'LD-CVSS' ); ?></th>
                        <td>
                            <label>
                                <input type="hidden" name="ld_cvss_settings[social_sharing_with_image]" value="false">
                                <input type="checkbox" name="ld_cvss_settings[social_sharing_with_image]" value="true" <?php checked( $options->get( 'social_sharing_with_image' ) ); ?>> <?php _e( 'Enable', 'LD-CVSS' ); ?>
                            </label>
                            <p class="description" style="margin: 20px 0 0;font-style:italic;"><?php _e( 'Enable certificate image sharing on the social media.', 'LD-CVSS' ); ?></p>
                        </td>
                    </tr>
                    <tr valign="top">
                        <th scope="row"><?php _e( 'LinkedIn company ID', 'LD-CVSS' ); ?></th>
                        <td>
                            <input class="regular-text" type="text" name="ld_cvss_settings[linkedin_company_id]" value="<?php echo esc_attr( $options->get( 'linkedin_company_id' ) ); ?>">
                            <p class="description" style="margin: 20px 0 0;font-style:italic;">
                                <?php 
                                printf(
                                    __( 'Please enter your LinkedIn company ID. %s.', 'LD-CVSS' ),
                                    sprintf( 
                                        '<a href="https://www.linkedin.com/help/linkedin/answer/a415420/associate-your-linkedin-company-id-with-the-linkedin-job-board-faqs" target="_blank">%s</a>',
                                        __( 'This article will help you to find it', 'LD-CVSS' )
                                    )
                                ); 
                                ?>
                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>
            <p class="submit">
                <button class="button button-primary" type="submit" name="ld_cvss_submit_form" value="<?php echo esc_attr( $form_actions['save_settings'] ); ?>"><?php _e( 'Save Settings', 'LD-CVSS' ); ?></button>
            </p>
        <?php elseif ( $active_tab == 'license' ) : ?>
            <p style=" margin:0 0 15px;font-size:16px;font-weight:bold;"><?php _e( 'Please enter your license key to get automatic updates.', 'LD-CVSS' );?></p>
            <table class="form-table">
                <tbody>
                    <tr valign="top">
                        <th scope="row"><?php _e( 'Status', 'LD-CVSS' ); ?></th>
                        <td>
                            <strong style="color:<?php echo $is_license_activated ? '#32ac96' : '#f15a5a'; ?>;"><?php echo $is_license_activated ? __( 'Active', 'LD-CVSS' ) : __( 'Inactive', 'LD-CVSS' ); ?></strong>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row" valign="top"><?php _e( 'License key', 'LD-CVSS' ); ?></th>
                        <td valign="top">
                            <div class="<?php echo $is_license_activated ? ' ld_cvss-hidden' : ''; ?>">
                                <input class="regular-text" type="text" name="ld_cvss_license[license_key]" value="<?php echo esc_attr( $options->get( 'license_key' ) ); ?>" placeholder="<?php _e( 'Enter your license key here', 'LD-CVSS' ); ?>">
                                <p class="description" style="margin: 20px 0 0;font-style:italic;"><?php printf( __( 'You can find the license key for %s add-on in the purchase email or on the %s page.', 'LD-CVSS' ), LD_CVSS_NAME, sprintf( '<a href="https://wooninjas.com/my-account/" class="ld-cvss-link" target="_blank">%s</a>', __( 'My account', 'LD-CVSS' ) ) ); ?></p>
                            </div>
                            <p class="submit">
                                <?php if ( ! $is_license_activated ) : ?>
                                    <button class="button button-primary" type="submit" name="ld_cvss_submit_form" value="<?php echo esc_attr( $form_actions['activate_license_key'] ); ?>"><?php _e( 'Activate license', 'LD-CVSS' ); ?></button>
                                <?php else : ?>
                                    <button class="button button-secondary" type="submit" name="ld_cvss_submit_form" value="<?php echo esc_attr( $form_actions['check_license_key'] ); ?>"><?php _e( 'Check license', 'LD-CVSS' ); ?></button>
                                    <button class="button button-primary" type="submit" name="ld_cvss_submit_form" value="<?php echo esc_attr( $form_actions['deactivate_license_key'] ); ?>"><?php _e( 'Deactivate license', 'LD-CVSS' ); ?></button>
                                <?php endif; ?>
                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>
        <?php endif; ?>
        <?php echo $nonce_field; ?>
    </form>
</div>