<?php
/**
 * Plugin Name: LearnDash Certificate Verify and Share
 * Plugin URI: https://wooninjas.com/downloads/learndash-certificate-verify-share
 * Description: This addon allows student to share their course certificates, quiz certificates, group certificates on FaceBook, Twitter, Linkedin, and social media visitors can verify the certificates shared on social media.
 * Version: 1.3.1
 * Requires at least: 5.1
 * Requires PHP: 5.6
 * Author: WooNinjas
 * Author URI: https://wooninjas.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: LD-CVSS
 * Domain Path: /languages
 */

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

require_once 'vendor/autoload.php';

if ( ! function_exists( 'get_plugin_data' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
}

$plugin_data        = get_plugin_data( __FILE__ );
$wp_upload_dir      = wp_get_upload_dir();

/* Define constants. */
! defined( 'LD_CVSS_VERSION' )                   && define( 'LD_CVSS_VERSION', $plugin_data['Version'] );
! defined( 'LD_CVSS_NAME' )                      && define( 'LD_CVSS_NAME', $plugin_data['Name'] );
! defined( 'LD_CVSS_BASE' )                      && define( 'LD_CVSS_BASE', basename( dirname( __FILE__ ) ) . '/' . basename( __FILE__ ) );
// ! defined( 'LD_CVSS_ASSETS_SUFFIX' )             && define( 'LD_CVSS_ASSETS_SUFFIX', ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG === true ? '' : '.min' ) );
! defined( 'LD_CVSS_ASSETS_SUFFIX' )             && define( 'LD_CVSS_ASSETS_SUFFIX', '' );
! defined( 'LD_CVSS_FILE' )                      && define( 'LD_CVSS_FILE', __FILE__ );
! defined( 'LD_CVSS_URL' )                       && define( 'LD_CVSS_URL', plugins_url( '', LD_CVSS_FILE ) );
! defined( 'LD_CVSS_URL_ASSETS' )                && define( 'LD_CVSS_URL_ASSETS', LD_CVSS_URL . '/assets' );
! defined( 'LD_CVSS_URL_ASSETS_CSS' )            && define( 'LD_CVSS_URL_ASSETS_CSS', LD_CVSS_URL_ASSETS . '/css' );
! defined( 'LD_CVSS_URL_ASSETS_JS' )             && define( 'LD_CVSS_URL_ASSETS_JS', LD_CVSS_URL_ASSETS . '/js' );
! defined( 'LD_CVSS_URL_ASSETS_IMAGES' )         && define( 'LD_CVSS_URL_ASSETS_IMAGES', LD_CVSS_URL_ASSETS . '/images' );
! defined( 'LD_CVSS_PATH' )                      && define( 'LD_CVSS_PATH', dirname( LD_CVSS_FILE ) );
! defined( 'LD_CVSS_PATH_ASSETS' )               && define( 'LD_CVSS_PATH_ASSETS', LD_CVSS_PATH . '/assets' );
! defined( 'LD_CVSS_PATH_ASSETS_IMAGES' )        && define( 'LD_CVSS_PATH_ASSETS_IMAGES', LD_CVSS_PATH_ASSETS . '/images' );
! defined( 'LD_CVSS_PATH_INCLUDES' )             && define( 'LD_CVSS_PATH_INCLUDES', LD_CVSS_PATH . '/includes' );
! defined( 'LD_CVSS_PATH_TEMPLATES' )            && define( 'LD_CVSS_PATH_TEMPLATES', LD_CVSS_PATH . '/templates' );
! defined( 'LD_CVSS_WP_UPLOAD_DIR' )             && define( 'LD_CVSS_WP_UPLOAD_DIR', $wp_upload_dir['basedir'] );
! defined( 'LD_CVSS_PATH_CERTIFICATES' )         && define( 'LD_CVSS_PATH_CERTIFICATES', LD_CVSS_WP_UPLOAD_DIR . '/ldcvss-certificates' );

if ( ! class_exists( 'LD_CVSS_Learndash_Certificate_Verify_And_Share' ) ) {
    class LD_CVSS_Learndash_Certificate_Verify_And_Share {
        /**
         * Init plugin.
         *
         * @return void
         */
        public function __construct() {
            new LD_CVSS\Init;
        }
    }
}

new LD_CVSS_Learndash_Certificate_Verify_And_Share;