<?php

namespace LD_CVSS\Upgrades;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

use LD_CVSS\Classes\Helper;

class Upgrade_108 {
    use \LD_CVSS\Traits\Trait_Singleton;

    /**
     * Constructor.
     * 
     * @return void
     */
    public function __construct() {
        add_action( 'ld_cvss_get_default_options', array( $this, 'upgrade_options' ) );
        add_action( 'init', array( $this, 'delete_old_certificates_folder' ) );
    }

    /**
     * @since 1.0.8
     *
     * Upgrade plugin options.
     * 
     * @param array $default_options Default plugin options.
     * 
     * @return array Changed default plugin options.
     * 
     */
    public function upgrade_options( $default_options ) {
        if ( 'LD_CVSS_OPTION_NOT_EXISTS' != get_option( 'verification_page_id', 'LD_CVSS_OPTION_NOT_EXISTS' ) ) {
            $default_options['verification_page_id'] = ( int ) get_option( 'verification_page_id' );
            delete_option( 'verification_page_id' );
        }

        if ( 'LD_CVSS_OPTION_NOT_EXISTS' != get_option( 'verification_page_template', 'LD_CVSS_OPTION_NOT_EXISTS' ) ) {
            $default_options['verification_page_template'] = get_option( 'verification_page_template' );
            delete_option( 'verification_page_template' );
        }

        if ( 'LD_CVSS_OPTION_NOT_EXISTS' != get_option( 'social_sharing_with_image', 'LD_CVSS_OPTION_NOT_EXISTS' ) ) {
            $default_options['social_sharing_with_image'] = ( bool ) get_option( 'social_sharing_with_image' );
            delete_option( 'social_sharing_with_image' );
        }

        if ( 'LD_CVSS_OPTION_NOT_EXISTS' != get_option( 'social_sharing_linkedin_company_id', 'LD_CVSS_OPTION_NOT_EXISTS' ) ) {
            $default_options['linkedin_company_id'] = get_option( 'social_sharing_linkedin_company_id' );
            delete_option( 'social_sharing_linkedin_company_id' );
        }

        if ( 'LD_CVSS_OPTION_NOT_EXISTS' != get_option( 'ld_cvss_license_key', 'LD_CVSS_OPTION_NOT_EXISTS' ) ) {
            $default_options['license_key'] = get_option( 'ld_cvss_license_key' );
            delete_option( 'ld_cvss_license_key' );
        }

        return $default_options;
    }

    /**
     * Delete old certificates folder.
     *
     * @return void
     */
    public function delete_old_certificates_folder() {
        $wp_filesystem = Helper::wp_filesystem();

        if ( $wp_filesystem->exists( LD_CVSS_WP_UPLOAD_DIR . '/certificates' ) ) {
            $wp_filesystem->rmdir( LD_CVSS_WP_UPLOAD_DIR . '/certificates', true );
        }
    }
}