<?php

namespace LD_CVSS\Traits;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

trait Trait_Singleton {
    /**
     * @var array Class instances.
     */
    protected static $_instances = array();

    /**
     * Constructor.
     * 
     * @return void
     */
    protected function __construct() {}

    /**
     * Clone.
     * 
     * @return void
     */
    final private function __clone() {}

    /**
     * Get class instance.
     * 
     * @return object Class instance.
     */
    final public static function get_instance() {
        $called_class = self::get_called_class();

        if ( ! isset( self::$_instances[ $called_class ] ) ) {
            self::$_instances[ $called_class ] = new $called_class();
        }

        return self::$_instances[ $called_class ];
    }

    /**
     * Get called class.
     * 
     * @return string Called class.
     */
    final private static function get_called_class() {
        if ( function_exists( 'get_called_class' ) ) {
            return get_called_class();
        } else {
            $debug_backtrace    = debug_backtrace();
            $line               = 0;

            do {
                $line++;

                $lines          = file( $debug_backtrace[ $line ]['file'] );
                $caller_line    = $lines[ $debug_backtrace[ $line ]['line'] - 1 ];

                preg_match( '/([a-zA-Z0-9\_]+)::' . $debug_backtrace[ $line ]['function'] . '/', $caller_line, $matches );
            } while ( $matches[ 1 ] === 'parent' && $matches[ 1 ] );
    
            return $matches[ 1 ];
        }
    }

	public function log( $log ){
		if( is_array($log) || is_object($log) ){
			error_log( print_r($log, true) );
		}else{
			error_log( $log );
		}
	}

}