<?php

namespace LD_CVSS\Plugins_Compatibility;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

use LD_CVSS\Classes\Verification_Page;

class Yoast_Seo {
    use \LD_CVSS\Traits\Trait_Singleton;

    private $verification_page;

    /**
     * Constructor.
     * 
     * @return void
     */
    public function __construct() {
        $this->verification_page = Verification_Page::get_instance();

        /**
         * Reference Articles:
         * https://bydik.com/remove-yoast-seo-meta-tags/
         * https://labs.thecreatology.com/squirrel/remove-wp-yoast-seo-meta-tags-using-wordpress-filter.html
         */
        add_filter( 'wpseo_title', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_robots', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_canonical', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_metadesc', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_metakeywords', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_locale', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_opengraph_title', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_opengraph_desc', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_opengraph_url', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_opengraph_type', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_opengraph_image', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_opengraph_site_name', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_opengraph_admin', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_opengraph_author_facebook', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_opengraph_show_publish_date', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_twitter_title', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_twitter_description', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_twitter_card_type', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_twitter_site', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_twitter_image', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_twitter_creator_account', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'wpseo_json_ld_output', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );

        /**
         * Reference Article:
         * https://gist.github.com/amboutwe/811e92b11e5277977047d44ea81ee9d4#file-yoast_seo_opengraph_remove_all_post14-php
         */
        add_filter( 'wpseo_frontend_presenter_classes', array( $this, 'remove_presenter_classes' ) );
    }

    /**
     * Remove Opengraph meta tags.
     *
     * @param mixed $value Opengraph meta tag.
     * 
     * @return mixed Changed Opengraph meta tag.
     */
    public function remove_opengraph_meta_tags( $value ) {
        $post = get_post();

        if ( $post && $this->verification_page->is_verification_page( $post->ID ) ) {
            return false;
        }

        return $value;
    }

    /**
     * Remove presenter classes responsible for displaying Opengraph meta tags.
     *
     * @param mixed $value Opengraph meta tag.
     * 
     * @return mixed Changed Opengraph meta tag.
     */
    public function remove_presenter_classes( $classes ) {
        $post = get_post();

        if ( $post && $this->verification_page->is_verification_page( $post->ID ) ) {

            $class_chunks = array(
                'Canonical_Presenter',
                'Rel_Prev_Presenter',
                'Rel_Next_Presenter',
                'Schema_Presenter',
                'Open_Graph',
                'Twitter'
            );

            $unnecessary_classes = preg_grep('/(' . implode('|', $class_chunks) . ')/', $classes);

            return array_diff($classes, $unnecessary_classes);
        }

        return $classes;
    }
}