<?php

namespace LD_CVSS\Plugins_Compatibility;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

use LD_CVSS\Classes\Verification_Page;

class WPML {

	use \LD_CVSS\Traits\Trait_Singleton;



	/**
	 * Constructor.
	 *
	 * @return void
	 */
	public function __construct() {
		add_filter('ld_cvss_verification_page_id', [$this, 'get_translation_id'], 10, 1 );
	}

	public function get_translation_id( $verification_page_id ){

		/**
		 * https://wpml.org/forums/topic/how-to-get-the-id-of-translated-page/
		 * https://wpml.org/documentation/support/wpml-coding-api/wpml-hooks-reference/#hook-605256
		 * https://wpml.org/documentation/support/wpml-coding-api/wpml-hooks-reference/
		 */

		// returns 'en'
		global $sitepress;

		if ( is_a( $sitepress, 'SitePress' ) ) {
			$current_lang = $sitepress->get_current_language();
			$source_post_id = $sitepress->get_object_id( $verification_page_id, get_post_type( $verification_page_id ), false, $current_lang );
			$source_post_title = get_the_title( $source_post_id );
			$is_translation = $source_post_id && $source_post_id !== $verification_page_id;
			if ( $is_translation ) {
				$verification_page_id = $source_post_id;
			}
		}

		return $verification_page_id;
	}

}