<?php

namespace LD_CVSS\Plugins_Compatibility;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

use LD_CVSS\Classes\Verification_Page;

class SEO_Press {
    use \LD_CVSS\Traits\Trait_Singleton;

    private $verification_page;

    /**
     * Constructor.
     * 
     * @return void
     */
    public function __construct() {
        $this->verification_page = Verification_Page::get_instance();

        add_filter( 'seopress_social_og_url', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'seopress_social_og_site_name', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'seopress_social_og_locale', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'seopress_social_og_type', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'seopress_social_og_author', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'seopress_social_og_section', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'seopress_social_og_tag', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'seopress_social_og_title', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'seopress_social_og_desc', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'seopress_social_og_thumb', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'seopress_social_twitter_card_summary', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'seopress_social_twitter_card_site', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'seopress_social_twitter_card_creator', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'seopress_social_twitter_card_title', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'seopress_social_twitter_card_desc', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
        add_filter( 'seopress_social_twitter_card_thumb', array( $this, 'remove_opengraph_meta_tags' ), 10, 1 );
    }

    /**
     * Remove Opengraph meta tags.
     *
     * @param string $value Opengraph meta tag.
     * 
     * @return array Changed Opengraph meta tag.
     */
    public function remove_opengraph_meta_tags( $value ) {
        $post = get_post();

        if ( $post && $this->verification_page->is_verification_page( $post->ID ) ) {
            return '';
        }

        return $value;
    }
}