<?php

namespace LD_CVSS\Plugins_Compatibility;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

use LD_CVSS\Classes\Verification_Page;

class Rank_Math_SEO {
    use \LD_CVSS\Traits\Trait_Singleton;

    private $verification_page;

    /**
     * Constructor.
     * 
     * @return void
     */
    public function __construct() {
        $this->verification_page = Verification_Page::get_instance();

        /**
         * Reference Article:
         * https://rankmath.com/kb/filters-hooks-api-developer/#change-specific-social-meta
         */
        add_action( 'rank_math/head', array( $this, 'remove_facebook_opengraph_meta_tags'), 10, 1 );
        add_filter( 'rank_math/head', array( $this, 'remove_twitter_opengraph_meta_tags'), 10, 1 );
    }

    /**
     * Remove Opengraph meta tags.
     * 
     * @return void
     */
    public function remove_facebook_opengraph_meta_tags() {
        $post = get_post();

        if ( $post && $this->verification_page->is_verification_page( $post->ID ) ) {
            remove_all_actions( 'rank_math/opengraph/facebook' );
        }
    }

    /**
     * Remove Twitter meta tags.
     * 
     * @return void
     */
    public function remove_twitter_opengraph_meta_tags() {
        $post = get_post();

        if ( $post && $this->verification_page->is_verification_page( $post->ID ) ) {
            remove_all_actions( 'rank_math/opengraph/twitter' );
        }
    }
}