<?php

namespace LD_CVSS\Plugins_Compatibility;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

use LD_CVSS\Classes\Verification_Page;

class All_In_One_SEO {
    use \LD_CVSS\Traits\Trait_Singleton;

    private $verification_page;

    /**
     * Constructor.
     * 
     * @return void
     */
    public function __construct() {
        $this->verification_page = Verification_Page::get_instance();

        add_filter( 'aioseo_facebook_tags', array( $this, 'remove_opengraph_meta_tags'), 10, 1 );
        add_filter( 'aioseo_twitter_tags', array( $this, 'remove_opengraph_meta_tags'), 10, 1 );
    }

    /**
     * Remove Opengraph meta tags.
     *
     * @param array $meta Opengraph meta tags.
     * 
     * @return array Changed Opengraph meta tags.
     */
    public function remove_opengraph_meta_tags( $meta ) {
        $post = get_post();

        if ( $post && $this->verification_page->is_verification_page( $post->ID ) ) {
            $meta = array();
        }

        return $meta;
    }
}