<?php

namespace LD_CVSS;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

use LD_CVSS\Classes\Options;
use LD_CVSS\Classes\Notices\Error_Notice;
use LD_CVSS\License\License_Manager;
use LD_CVSS\License\Plugin_Updater;

class Plugin {
    use \LD_CVSS\Traits\Trait_Singleton;

    /**
     * Constructor.
     * 
     * @return void
     */
    public function __construct() {
        License_Manager::get_instance()->set_plugin_name( LD_CVSS_NAME );

        add_action( 'admin_notices', array( $this, 'admin_notices' ) );

        if ( Options::get_instance()->get( 'license_key' ) ) {
            new Plugin_Updater( 'https://wooninjas.com', LD_CVSS_FILE, array(
                'version'   => LD_CVSS_VERSION,
                'license'   => Options::get_instance()->get( 'license_key' ),
                'item_name' => LD_CVSS_NAME,
                'author'    => 'Wooninjas'
            ) );
        }
    }

    /**
     * Admin notices.
     * 
     * @return void
     */
    public function admin_notices() {
        $license_manager    = License_Manager::get_instance()->set_license_key( Options::get_instance()->get( 'license_key' ) );
        $attempt_check      = $license_manager->check();

        if ( is_wp_error( $attempt_check ) ) {
            $error = new Error_Notice;

            

            echo $error->get_html( 'check_license_key' );
        }
    }
}