<?php

namespace LD_CVSS;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

use LD_CVSS\Classes\Notices\Error_Notice;
use LD_CVSS\Classes\Options;
use LD_CVSS\Classes\Helper;

class Init {
    /**
     * Constructor.
     * 
     * @return void
     */
    public function __construct() {
        add_action( 'plugins_loaded', array( $this, 'load_plugin_textdomain' ) );

        if ( ! Helper::is_learndash_active() ) {
            add_action( 'admin_notices', array( $this, 'admin_notices' ) );

            return;
        }

        add_action( 'init', array( $this, 'create_certificates_folder' ) );

        $this->init();
    }

    /**
     * Plugin localization.
     * 
     * @return void
     */
    public function load_plugin_textdomain() {
        $domain         = 'LD-CVSS';
        $wp_lang_dir    = untrailingslashit( WP_LANG_DIR );
        $locale         = apply_filters( 'plugin_locale', get_locale(), $domain );
        $exists         = load_textdomain( $domain, $wp_lang_dir . '/plugins/' . $domain . '-' . $locale . '.mo' );

        if ( ! $exists ) {
            load_plugin_textdomain( $domain, FALSE, basename( dirname( LD_CVSS_FILE ) ) . '/languages/' );
        }
    }

    /**
     * Dashboard admin notices.
     * 
     * @return void
     */
    public function admin_notices() {
        $error = new Error_Notice;
        $error->add( 'missing_required_plugin', sprintf( 
            __( '%s plugin requires %s plugin activated.', 'LD-CVSS' ),
            sprintf( '<strong>%s</strong>', LD_CVSS_NAME ),
            '<strong>LearnDash LMS</strong>'
        ) );

        echo $error->get_html( 'missing_required_plugin' );
    }

    /**
     * Instances initialization.
     * 
     * @return void
     */
    public function init() {
        Upgrade::get_instance();
        Options::get_instance();
        Plugin::get_instance();
        Plugin_Compatibility::get_instance();
        Admin::get_instance();
        URL::get_instance();
        Frontend::get_instance();
    }

    public function create_certificates_folder() {
        $wp_filesystem = Helper::wp_filesystem();

        if ( ! $wp_filesystem->exists( LD_CVSS_PATH_CERTIFICATES ) ) {
            $wp_filesystem->mkdir( LD_CVSS_PATH_CERTIFICATES );
        }
    }
}