<?php

namespace LD_CVSS\Deprecated;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

/**
 * @deprecated since 1.0.8
 * 
 * Refrence: https://stackoverflow.com/questions/12102670/php-form-example-which-will-encrypt-query-string-get-data-hiding-rather-tha/50253647#50253647
 */
class Base64_Security {
    /**
     * @var string Chiper.
     */
    const CIPHER = 'aes-256-cbc';

    /**
     * Safe base64 encode.
     *
     * @param string $string String to encode.
     * 
     * @return string Encoded string.
     */
    public static function safe_b64encode( $string = '' ) {
        $data = base64_encode( $string );
        $data = str_replace( array( '+', '/', '=' ), array( '-', '_', '' ), $data );

        return $data;
    }

    /**
     * Safe base64 decode.
     *
     * @param string $string Encoded string.
     * 
     * @return string Decoded string.
     */
    public static function safe_b64decode( $string = '' ) {
        $data = str_replace( array( '-', '_' ), array( '+', '/' ), $string );
        $mod4 = strlen( $data ) % 4;

        if ( $mod4 ) {
            $data .= substr( '====', $mod4 );
        }
        return base64_decode( $data );
    }

    /**
     * Encode string with OpenSSL.
     *
     * @param string $value String to encode.
     * 
     * @return string Encoded string.
     */
    public static function encode( $value = '' ) {
        if ( ! $value ) {
            return '';
        }

        $iv_size    = openssl_cipher_iv_length( self::CIPHER );
        $iv         = openssl_random_pseudo_bytes( $iv_size );
        $crypttext  = openssl_encrypt( $value, self::CIPHER, 'your security cipherSeed', OPENSSL_RAW_DATA, $iv );

        return self::safe_b64encode( $iv . $crypttext ); 
    }

    /**
     * Decode string with OpenSSL.
     *
     * @param string $value Encoded string.
     * 
     * @return string Decoded string.
     */
    public static function decode( $value = '' ) {
        if ( ! $value ) {
            return '';
        }

        $crypttext  = self::safe_b64decode( $value );
        $iv_size    = openssl_cipher_iv_length( self::CIPHER );
        $iv         = substr( $crypttext, 0, $iv_size );
        $crypttext  = substr( $crypttext, $iv_size );
        
        if ( ! $crypttext ) {
            return false;
        }

        $decrypttext = openssl_decrypt( $crypttext, self::CIPHER, 'your security cipherSeed', OPENSSL_RAW_DATA, $iv );

        return rtrim( $decrypttext );
    }

    /**
     * Get decoded data from decoded string.
     *
     * @param string $value Decoded string.
     * 
     * @return array Decoded data.
     */
    public static function get_decoded_data( $decoded_string ) {
        $data           = array();
        $pairs          = explode( '&', $decoded_string );
        $replacement    = array(
            'user-id'       => 'user_id',
            'course-id'     => 'source_id',
            'quiz-id'       => 'source_id',
            'group-id'      => 'source_id'
        );

        if ( $pairs ) {
            foreach( $pairs as $pair_str ) {
                $sub_pairs      = explode( ':', $pair_str );
                $pair_key       = $sub_pairs[0];
                $pair_key       = str_replace( array_keys( $replacement ), array_values( $replacement ), $sub_pairs[0] );
                $pair_value     = $sub_pairs[1];

                if ( $pair_key == 'certificate-type' ) {
                    continue;
                }

                $data[ $pair_key ] = ( int ) $pair_value;
            }
        }

        return $data;
    }
}