<?php

namespace LD_CVSS\Classes;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

use LD_CVSS\Frontend;

class Verification_Page {
    use \LD_CVSS\Traits\Trait_Singleton;

    /**
     * @var null|WP_Post Certification page post. 
     */
    private $page;

    /**
     * Constructor.
     * 
     * @return void
     */
    public function __construct() {
        $this->options = Options::get_instance();

        $page = get_post( $this->options->get( 'verification_page_id', 0 ) );

        if ( $page ) {
            $this->page = $page;
        }
    }

    /**
     * Get page post.
     * 
     * @return null|WP_Post Page post.
     */
    public function get_post() {
	    $verification_page_id =  apply_filters('ld_cvss_verification_page_id', intval($this->options->get( 'verification_page_id', 0 )) );
		if( ! empty($verification_page_id) && 0 != $verification_page_id ){
			$this->page = get_post( $verification_page_id );
		}
		return $this->page;
    }

    /**
     * Check if verification page exists.
     * 
     * @return bool Result of cheking.
     */
    public function page_exists() {
        return ! is_null( $this->get_post() );
    }

    /**
     * Get page ID
     * 
     * @return int Page ID.
     */
    public function get_page_id() {
        return $this->page_exists() ? $this->get_post()->ID : 0;
    }

    /**
     * Get page URL.
     *
     * @return string Page URL.
     */
    public function get_page_url() {
        return $this->page_exists() ? get_the_permalink( $this->get_page_id() ) : '';
    }

    /**
     * Get current URL.
     * 
     * @return string Current URL.
     */
    public function get_current_url() {
        global $wp;

        return user_trailingslashit( home_url( $wp->request ) );
    }
    

    /**
     * Check if the current page is the verification page.
     * 
     * @return bool Result of cheking.
     */
    public function is_verification_page( $page_id = 0 ) {
        $post = get_post();

        if ( ! $page_id && $post ) {
            $page_id = $post->ID;
        }

        return $page_id && $this->get_page_id() && $page_id == $this->get_page_id();
    }
}