<?php

namespace LD_CVSS\Classes;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

class Template {
    /**
     * Get the template.
     *
     * @param string $template Path to the template file.
     * @param array $template_data Template data.
     * 
     * @return string HTML of the template.
     */
    public static function get( $template, $template_data = array() ) {
        return self::html( $template, $template_data );
    }

    /**
     * Render the template.
     *
     * @param string $template Path to the template file.
     * @param array $template_data Template data.
     * 
     * @return void
     */
    public static function render( $template, $template_data = array() ) {
        echo self::html( $template, $template_data );
    }

    /**
     * Get the template.
     *
     * @param string $template Path to the template file.
     * @param array $template_data Template data.
     * 
     * @return void|string HTML of the template.
     */
    private static function html( $template, $template_data ) {
        $template_data  = apply_filters( 'ld_cvss_template_data', $template_data, $template );
        $template_file  = apply_filters( 'ld_cvss_template_file', LD_CVSS_PATH_TEMPLATES . '/' . trim( $template, '/' ), $template, $template_data );

        if ( file_exists( $template_file ) ) {
            ob_start();
            do_action( 'ld_cvss_before_template', $template, $template_file, $template_data );
            extract( $template_data );
            require $template_file;
            do_action( 'ld_cvss_after_template', $template, $template_file, $template_data );
            return ob_get_clean();
        } else {
            throw new \Exception( 'Template ' . $template . ' not found.' );
        }
    }
}