<?php

namespace LD_CVSS\Classes;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

use LD_CVSS\Classes\Notices\Error_Notice;
use LD_CVSS\Classes\Notices\Success_Notice;
use LD_CVSS\Classes\Notices\Warning_Notice;
use LD_CVSS\Classes\Notices\Info_Notice;

class Notice_Manager {
    /**
     * @var object instance of Notice_Error.
     */
    private $error;

    /**
     * @var object instance of Notice_Success.
     */
    private $success;

    /**
     * @var object instance of Notice_Warning.
     */
    private $warning;

    /**
     * @var object instance of Notice_Info.
     */
    private $info;

    /**
     * Constructor.
     * 
     * @return void
     */
    public function __construct() {
        $this->error        = new Error_Notice;
        $this->success      = new Success_Notice;
        $this->warning      = new Warning_Notice;
        $this->info         = new Info_Notice;
    }

    /**
     * Get notices by type.
     *
     * @param string $type Notice type.
     * 
     * @return object|null Instance of Notice_Error|Notice_Success|Notice_Warning|Notice_Info.
     */
    public function __get( $type ) {
        return property_exists( $this, $type ) ? $this->$type : null;
    }
}