<?php

namespace LD_CVSS\Classes\Certificate_Sources;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

use LD_CVSS\Classes\Certificate_Source;

class Certificate_Source_Quiz extends Certificate_Source {
    /**
     * @var string Source type.
     */
    const TYPE = 'quiz';

    /**
     * Get course.
     *
     * @return null|object Course (WP_Post).
     */
    public function get_course() {
        $course_id = ( int ) learndash_get_setting( $this->get_id(), 'course' );

        return $course_id > 0 ? get_post( $course_id ) : null;
    }

   /**
     * Get Instructor ID.
     * 
     * @return int Instructor ID.
     */
    public function get_instructor_id() {
        $course = $this->get_course();

        return $course ? $course->post_author : 0;
    }

    /**
     * Get issue date.
     * 
     * @return int Issue date timestamp.
     */
    public function get_issue_date() {
        $quiz_attempt = $this->user_get_quiz_progress( $this->get_user_id(), $this->get_id() );

        return ! is_null( $quiz_attempt ) ? ( int ) $quiz_attempt['completed'] : 0;
    }

    /**
     * Get source URL args.
     *
     * @return array PDF URL args.
     */
    public function get_pdf_url_args() {
        return array( 
            'quiz'      => $this->get_id(),
            'user_id'   => $this->get_user_id()
        );
    }

    /**
     * Check if source is completed.
     *
     * @return bool result of checking.
     */
    public function is_completed() {
        $quiz_attempt = $this->user_get_quiz_progress( $this->get_user_id(), $this->get_id() );

        return ! is_null( $quiz_attempt );
    }

    /**
     * Get user quiz progress.
     *
     * @return null|array Source passed quiz.
     */
    private function user_get_quiz_progress( $user_id, $quiz_id ) {
        $passed_quiz            = null;
        $quiz_progress          = learndash_user_get_quiz_progress( $user_id, $quiz_id );
        $quiz_progress          = array_reverse( $quiz_progress );
        $certificate_threshold  = learndash_get_setting( $quiz_id, 'threshold' );

        if ( $certificate_threshold ) {
            foreach ( $quiz_progress as $quiz ) {
                if ( 
                    ( ! empty( $quiz['percentage'] ) && $quiz['percentage'] >= $certificate_threshold * 100 ) || 
                    ( ! empty( $quiz['count'] ) && $quiz['score'] / $quiz['count'] >= $certificate_threshold )
                ) {
                    $passed_quiz = $quiz;

                    break;
                }
            }
        }

        return $passed_quiz;
    }
}