<?php

namespace LD_CVSS\Classes\Certificate_Sources;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

use LD_CVSS\Classes\Certificate_Source;

class Certificate_Source_Group extends Certificate_Source {
    /**
     * @var string Source type.
     */
    const TYPE = 'group';

    /**
     * Get course.
     *
     * @return array Array of courses (WP_Post).
     */
    public function get_course() {
        $course_ids     = learndash_group_enrolled_courses( $this->get_id() );
        $courses        = array();

        foreach ( $course_ids as $course_id ){
            $courses[] = get_post( $course_id );
        }

        return $courses;
    }

   /**
     * Get Instructor ID.
     * 
     * @return int Instructor ID.
     */
    public function get_instructor_id() {
        $group = get_post( $this->get_id() );

        return $group ? $group->post_author : 0;
    }

    /**
     * Get issue date.
     * 
     * @return int Issue date timestamp.
     */
    public function get_issue_date() {
        return ( int ) learndash_get_user_group_completed_timestamp( $this->get_id(), $this->get_user_id() );
    }

    /**
     * Get source URL args.
     *
     * @return array PDF URL args.
     */
    public function get_pdf_url_args() {
        return array( 
            'group_id'  => $this->get_id(),
            'user_id'   => $this->get_user_id()
        );
    }

    /**
     * Check if source is completed.
     *
     * @return bool result of checking.
     */
    public function is_completed() {
        return learndash_get_user_group_status( $this->get_id(), $this->get_user_id(), true ) == 'completed';
    }
}