<?php

namespace LD_CVSS\Classes\Certificate_Sources;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

use LD_CVSS\Classes\Certificate_Source;

class Certificate_Source_Course extends Certificate_Source {
    /**
     * @var string Source type.
     */
    const TYPE = 'course';

    /**
     * Get course.
     *
     * @return null|object Course (WP_Post).
     */
    public function get_course() {
        return $this->source;
    }

    /**
     * Get Instructor ID.
     * 
     * @return int Instructor ID.
     */
    public function get_instructor_id() {
        $course = $this->get_course();

        return $course ? $course->post_author : 0;
    }

    /**
     * Get issue date.
     * 
     * @return int Issue date timestamp.
     */
    public function get_issue_date() {
        return ( int ) learndash_user_get_course_completed_date( $this->get_user_id(), $this->get_id() );
    }

    /**
     * Get source URL args.
     *
     * @return array PDF URL args.
     */
    public function get_pdf_url_args() {
        return array( 
            'course_id' => $this->get_id(),
            'user_id'   => $this->get_user_id()
        );
    }

    /**
     * Check if source is completed.
     *
     * @return bool result of checking.
     */
    public function is_completed() {
        return learndash_course_status( $this->get_id(), $this->get_user_id(), true ) == 'completed';
    }
}