<?php

namespace LD_CVSS\Classes;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

abstract class Certificate_Source {
    /**
     * @var object Source (WP_Post).
     */
    protected $source;

    /**
     * @var int User ID.
     */
    protected $user_id;

    /**
     * Constructor.
     *
     * @param object $source Source.
     * @param int $user_id User ID.
     * 
     * @return void
     */
    public function __construct( $source, $user_id ) {
        $this->source   = $source;
        $this->user_id   = $user_id;
    }

    /**
     * Get source ID.
     *
     * @return int Source ID.
     */
    public function get_id() {
        return $this->source ? $this->source->ID : 0;
    }

    /**
     * Get source post.
     *
     * @return object Source post.
     */
    public function get_post() {
        return $this->get_id() ? $this->source : null;
    }

    /**
     * Get source user ID.
     *
     * @return int User ID.
     */
    public function get_user_id() {
        return $this->user_id;
    }

    /**
     * Get source type.
     *
     * @return string Certificate type.
     */
    public function get_type() {
        return static::TYPE;
    }

    /**
     * Get certificate ID.
     *
     * @return int Certificate ID.
     */
    public function get_certificate_id() {
        return ( int ) learndash_get_setting( $this->get_id(), 'certificate' );
    }

    /**
     * Get source course.
     *
     * @return null|WP_Post|array Certificate course.
     */
    abstract public function get_course();

    /**
     * Get source instructor ID.
     * 
     * @return int Instructor ID.
     */
    abstract public function get_instructor_id();

    /**
     * Get source issue date.
     * 
     * @return int Issue date timestamp.
     */
    abstract public function get_issue_date();

    /**
     * Get source PDF URL args.
     *
     * @return array URL args.
     */
    abstract public function get_pdf_url_args();

    /**
     * Check if source is completed.
     *
     * @return bool result of checking.
     */
    abstract public function is_completed();
}