<?php

namespace LD_CVSS\Classes;

/* Exit if accessed directly. */
defined( 'ABSPATH' ) || exit;

class Certificate_Access {
    /**
     * Check if a user is the certificate owner.
     *
     * @param object $certificate Instance of Certificate class.
     * 
     * @return bool Result of checking.
     */
    public static function is_owner( $certificate ) {
        if ( ! Helper::is_ld_pay_for_quiz_certificate_active() ) {
            return true;
        }

        if ( ! is_user_logged_in() ) {
            return false;
        }

        $current_user_id        = get_current_user_id();
        $certificate_user_id    = $certificate->get_user_id();

        return $current_user_id && $certificate_user_id && $current_user_id == $certificate_user_id;
    }

    /**
     * Check if a user can view the certificate.
     *
     * @param object $certificate Instance of Certificate class.
     * 
     * @return bool Result of checking.
     */
    public static function is_viewable( $certificate ) {
        if ( ! Helper::is_ld_pay_for_quiz_certificate_active() ) {
            return true;
        }

        if ( ! is_user_logged_in() ) {
            return false;
        }

        return self::is_owner( $certificate ) || current_user_can( 'administrator' );
    }

    /**
     * Check if a user purchased the certificate.
     *
     * @param object $certificate Instance of Certificate class.
     * 
     * @return bool Result of checking.
     */
    public static function is_purchased( $certificate ) {
        if ( ! Helper::is_ld_pay_for_quiz_certificate_active() ) {
            return true;
        }

        return \LD_Pay_For_Quiz_Access_Class::is_accessible( $certificate->get_id(), $certificate->get_user_id() );
    }

    /**
     * Check if a user purchased the certificate.
     *
     * @param object $certificate Instance of Certificate class.
     * 
     * @return bool Result of checking.
     */
    public static function get_purchase_button( $certificate ) {
        if ( ! Helper::is_ld_pay_for_quiz_certificate_active() ) {
            return '';
        }

        return \LD_Pay_For_Quiz_Access_Class::get_purchase_button( $certificate->get_id() );
    }
}