var gulp                = require('gulp'),
    sass                = require('gulp-sass'),
    compiler            = require('sass'),
    cssbeautify         = require('gulp-cssbeautify'),
    rename              = require('gulp-rename'),
    jsmin               = require('gulp-jsmin'),
    removeEmptyLines    = require('gulp-remove-empty-lines'),
    zip                 = require('gulp-zip'),
    clean               = require('gulp-clean'),
    fs                  = require('fs'),
    tempDir             = '__temp__',
    plugin              = 'learndash-certificate-verify-and-share';

sass.compiler = compiler;

gulp.task('css', function() {
    return gulp.src('assets/css/sass/*.scss')
        .pipe(sass({
            outputStyle: 'expanded'
        }).on('error', sass.logError))
        .pipe(cssbeautify())
        .pipe(gulp.dest('assets/css'))
});

gulp.task('css-minified', function() {
    return gulp.src('assets/css/sass/*.scss')
        .pipe(sass({
            outputStyle: 'compressed'
        }).on('error', sass.logError))
        .pipe(removeEmptyLines())
        .pipe(rename({ suffix: '.min' }))
        .pipe(gulp.dest('assets/css'))
});

gulp.task('js-minified', function() {
    return gulp.src('assets/js/!(*.min).js')
        .pipe(jsmin())
        .pipe(removeEmptyLines())
        .pipe(rename({suffix: '.min'}))
        .pipe(gulp.dest('assets/js'))
});

gulp.task('watch', function() {
    gulp.watch('assets/css/sass/*.scss', gulp.series(['css', 'css-minified']));
    gulp.watch('assets/js/!(*.min).js', gulp.series('js-minified'));
});

// Build plugin
gulp.task('temp', function() {
    return gulp.src([
        "./**/*.*",
        "!composer.json",
        "!composer.lock",
        "!package.json",
        "!package-lock.json",
        "!gulpfile.js",
        "!.gitignore",
        "!.vscode",
        "!webpack.config.js",
        "!node_modules/**",
        "!./**/{sass,sass/**/*}",
        "!*.zip"
    ])
    .pipe(gulp.dest('./' + tempDir + '/' + plugin));
});

gulp.task('zip', function() {
    var content = fs.readFileSync( plugin + '.php', "utf8"),
        regexp = /Version.+/ig,
        matches = regexp.exec(content),
        file = plugin;

    if (matches) {
        file += '-' + matches[0].split(' ')[1];
    }

    return gulp.src('./' + tempDir + '/**/*.*')
        .pipe(zip(file + '.zip'))
        .pipe(gulp.dest('./'));
});

gulp.task('clean', function() {
    return gulp.src('./' + tempDir, {read: false})
        .pipe(clean())
});

gulp.task('build', gulp.series(['temp', 'zip', 'clean']));