jQuery( function( $ ) {
    if ( 'undefined' === typeof ld_cvss_quiz_data ) {
        return false;
    }

    $( document ).ajaxComplete(function( event, request, settings ) {
        if ( typeof settings.data == 'string' && settings.data.search( 'action=wp_pro_quiz_completed_quiz' ) != -1 ) {
            var response = JSON.parse( request.responseText );
            if ( typeof response == 'object' ) {
                for ( key in response ) {
                    if ( typeof response[ key ] == 'object' && 'quiz_result_settings' in response[ key ] && ld_cvss_quiz_data.json_param in response[ key ]['quiz_result_settings'] ) {
                        $( '.wpProQuiz_certificate' ).prepend( response[ key ]['quiz_result_settings'][ ld_cvss_quiz_data.json_param ] );
                        if( ld_cvss_quiz_data.certificate_url in response[ key ]['quiz_result_settings'] ){
                            $('.ld-cvss-social-buttons').siblings('a').attr('href', response[ key ]['quiz_result_settings'][ ld_cvss_quiz_data.certificate_url ] );
                        }
                    }
                }
            }
        }
    } );
} );