jQuery( function( $ ) {
    if ( 'undefined' === typeof ld_cvss_pdf2image_data ) {
        return false;
    }

    var pdfjsLib = window['pdfjs-dist/build/pdf'];

    /* The workerSrc property shall be specified. */
    pdfjsLib.GlobalWorkerOptions.workerSrc = ld_cvss_pdf2image_data.worker;

    /* Asynchronous download of PDF. */
    var loadingTask = pdfjsLib.getDocument( ld_cvss_pdf2image_data.pdf );

    loadingTask.promise.then( function( pdf ) {
        /* PDF loaded. */
        /* Fetch the first page. */
        var pageNumber = 1;

        pdf.getPage( pageNumber ).then( function( page ) {
            /* Page loaded. */

            var scale = 1.5,
                viewport = page.getViewport( { scale: scale } );

            /* Prepare canvas using PDF page dimensions */
            var canvas      = document.getElementById( 'ld-cvss-pdf2image-canvas' ),
                context     = canvas.getContext( '2d' );

            canvas.height   = viewport.height;
            canvas.width    = viewport.width;

            /* Render PDF page into canvas context */
            var renderContext = {
                canvasContext   : context,
                viewport        : viewport
            };

            var addBlur = function( blur, context ) {
                let sum         = 0;
                let delta       = 5;
                let alpha_left  = 1 / ( 2 * Math.PI * delta * delta );
                let step        = blur < 3 ? 1 : 2;

                for ( let y = -blur; y <= blur; y += step ) {
                    for ( let x = -blur; x <= blur; x += step ) {
                        let weight = alpha_left * Math.exp( -( x * x + y * y ) / ( 2 * delta * delta ) );
                        sum += weight;
                    }
                }

                let count = 0;

                for ( let y = -blur; y <= blur; y += step ) {
                    for ( let x = -blur; x <= blur; x += step ) {
                        count++;
                        context.globalAlpha = alpha_left * Math.exp( -( x * x + y * y ) / ( 2 * delta * delta ) ) / sum * blur;
                        context.drawImage( canvas, x, y );
                    }
                }

                context.globalAlpha = 1;
            }

            var renderTask = page.render( renderContext );

            renderTask.promise.then( function () {
                /* Page rendered */

                /* Blur the certificate if it's not purchased */
                if ( ld_cvss_pdf2image_data.is_purchased !== 'true' ) {
                    addBlur( 20, context );
                }

                $( document ).trigger( 'ld_cvss.pdf2image.rendered', { 
                    pdf             : ld_cvss_pdf2image_data.pdf,
                    canvas          : canvas,
                    is_purchased    :ld_cvss_pdf2image_data.is_purchased
                } );
            } );
        } );
    }, function ( reason ) {
        /* PDF loading error */

        $( document ).trigger( 'ld_cvss.pdf2image.error', { reason: reason } );
    } );
} );