jQuery( function( $ ) {
    if ( 'undefined' === typeof ld_cvss_pdf2image_data ) {
        return false;
    }

    $( document ).on( 'ld_cvss.pdf2image.rendered', function( e, data ) {
        if ( 'canvas' in data ) {
            $.ajax( {
                method      : 'post',
                url         : ld_cvss_pdf2image_data.ajax_url,
                dataType    : 'json',
                data        : {
                    action  : ld_cvss_pdf2image_data.ajax_action,
                    nonce   : ld_cvss_pdf2image_data.ajax_nonce,
                    csuid   : ld_cvss_pdf2image_data.csuid,
                    image   : data.canvas.toDataURL( ld_cvss_pdf2image_data.mime_type )
                },
                beforeSend: function( xhr ) {
                    xhr.setRequestHeader( 'X-WP-Nonce', ld_cvss_pdf2image_data.ajax_nonce );
                }
            } );
        }
    } );
} );