<?php
/**
 * Plugin Name: FileBird
 * Plugin URI: https://ninjateam.org/wordpress-media-library-folders/
 * Description: Organize thousands of WordPress media files into folders/ categories at ease.
 * Version: 6.3.3
 * Author: نوین وردپرس
 * Author URI: wpnovin.com
 * Text Domain: filebird
 * Domain Path: /i18n/languages/
 *
 * @package FileBirdPlugin
 */

namespace FileBird;
use Puc_v4_Factory;


defined( 'ABSPATH' ) || exit;

if ( function_exists( 'FileBird\\init' ) ) {
	require_once plugin_dir_path( __FILE__ ) . 'includes/Fallback.php';
	add_action( 'admin_init', function(){
		deactivate_plugins( plugin_basename( __FILE__ ) );
	});
	return;
}

if ( ! defined( 'NJFB_PREFIX' ) ) {
	define( 'NJFB_PREFIX', 'filebird' );
}

if ( ! defined( 'NJFB_VERSION' ) ) {
	define( 'NJFB_VERSION', '6.3.3' );
}

if ( ! defined( 'NJFB_PLUGIN_FILE' ) ) {
	define( 'NJFB_PLUGIN_FILE', __FILE__ );
}

if ( ! defined( 'NJFB_PLUGIN_URL' ) ) {
	define( 'NJFB_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! defined( 'NJFB_PLUGIN_PATH' ) ) {
	define( 'NJFB_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'NJFB_PLUGIN_BASE_NAME' ) ) {
	define( 'NJFB_PLUGIN_BASE_NAME', plugin_basename( __FILE__ ) );
}

if ( ! defined( 'NJFB_REST_URL' ) ) {
	define( 'NJFB_REST_URL', 'filebird/v1' );
}

if ( ! defined( 'NJFB_REST_PUBLIC_URL' ) ) {
	define( 'NJFB_REST_PUBLIC_URL', 'filebird/public/v1' );
}

if ( ! defined( 'NJFB_UPLOAD_DIR' ) ) {
	define( 'NJFB_UPLOAD_DIR', 'filebird-uploads' );
}


spl_autoload_register(
	function ( $class ) {
		$prefix   = __NAMESPACE__; // project-specific namespace prefix
		$base_dir = __DIR__ . '/includes'; // base directory for the namespace prefix

		$len = strlen( $prefix );
		if ( strncmp( $prefix, $class, $len ) !== 0 ) { // does the class use the namespace prefix?
			return; // no, move to the next registered autoloader
		}

		$relative_class_name = substr( $class, $len );

		// replace the namespace prefix with the base directory, replace namespace
		// separators with directory separators in the relative class name, append
		// with .php
		$file = $base_dir . str_replace( '\\', '/', $relative_class_name ) . '.php';

		if ( file_exists( $file ) ) {
			require $file;
		}
	}
);

if ( ! function_exists( 'FileBird\\init' ) ) {
	function init() {
		Plugin::getInstance();
		Plugin::activate();

		I18n::loadPluginTextdomain();

		Classes\ACF::getInstance();
		Classes\Convert::getInstance();
		Classes\PageBuilders::getInstance();
		Classes\Feedback::getInstance();
		Classes\Review::getInstance();
		Classes\DocumentGallery::getInstance();

		Classes\TabActive::getInstance();

		Page\Settings::getInstance();
		Controller\Folder::getInstance();
		Controller\FolderUser::getInstance();
		Controller\CompatibleWpml::getInstance();
		Controller\CompatiblePolylang::getInstance();

		Controller\Api::getInstance();

		if ( function_exists( 'register_block_type' ) ) {
			require plugin_dir_path( __FILE__ ) . 'blocks/filebird-gallery/src/init.php';
		}
	}
}
add_action( 'plugins_loaded', 'FileBird\\init' );

register_activation_hook( __FILE__, array( 'FileBird\\Plugin', 'activate' ) );
register_deactivation_hook( __FILE__, array( 'FileBird\\Plugin', 'deactivate' ) );

require_once plugin_dir_path( __FILE__ ) . 'novin-update/wpnovin-atuo-update.php';

$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
    	'http://dl3.wpnovin.com/Source/Plugins/filebird-pro/5d4gv5f5fg584655.json',
    	__FILE__,
    	'filebird-pro'
);
