<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataflow;

class StageSummary extends \Google\Collection
{
  protected $collection_key = 'metrics';
  /**
   * @var string
   */
  public $endTime;
  protected $metricsType = MetricUpdate::class;
  protected $metricsDataType = 'array';
  public $metrics;
  protected $progressType = ProgressTimeseries::class;
  protected $progressDataType = '';
  public $progress;
  /**
   * @var string
   */
  public $stageId;
  /**
   * @var string
   */
  public $startTime;
  /**
   * @var string
   */
  public $state;
  protected $stragglerSummaryType = StragglerSummary::class;
  protected $stragglerSummaryDataType = '';
  public $stragglerSummary;

  /**
   * @param string
   */
  public function setEndTime($endTime)
  {
    $this->endTime = $endTime;
  }
  /**
   * @return string
   */
  public function getEndTime()
  {
    return $this->endTime;
  }
  /**
   * @param MetricUpdate[]
   */
  public function setMetrics($metrics)
  {
    $this->metrics = $metrics;
  }
  /**
   * @return MetricUpdate[]
   */
  public function getMetrics()
  {
    return $this->metrics;
  }
  /**
   * @param ProgressTimeseries
   */
  public function setProgress(ProgressTimeseries $progress)
  {
    $this->progress = $progress;
  }
  /**
   * @return ProgressTimeseries
   */
  public function getProgress()
  {
    return $this->progress;
  }
  /**
   * @param string
   */
  public function setStageId($stageId)
  {
    $this->stageId = $stageId;
  }
  /**
   * @return string
   */
  public function getStageId()
  {
    return $this->stageId;
  }
  /**
   * @param string
   */
  public function setStartTime($startTime)
  {
    $this->startTime = $startTime;
  }
  /**
   * @return string
   */
  public function getStartTime()
  {
    return $this->startTime;
  }
  /**
   * @param string
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return string
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * @param StragglerSummary
   */
  public function setStragglerSummary(StragglerSummary $stragglerSummary)
  {
    $this->stragglerSummary = $stragglerSummary;
  }
  /**
   * @return StragglerSummary
   */
  public function getStragglerSummary()
  {
    return $this->stragglerSummary;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(StageSummary::class, 'Google_Service_Dataflow_StageSummary');
