<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class NlpSemanticParsingModelsCommunicationPhoneType extends \Google\Model
{
  protected $evalDataType = NlpSemanticParsingAnnotationEvalData::class;
  protected $evalDataDataType = '';
  public $evalData;
  /**
   * @var bool
   */
  public $isAnnotatedFromText;
  /**
   * @var string
   */
  public $normalizedText;
  /**
   * @var string
   */
  public $originalText;
  /**
   * @var string
   */
  public $rawText;

  /**
   * @param NlpSemanticParsingAnnotationEvalData
   */
  public function setEvalData(NlpSemanticParsingAnnotationEvalData $evalData)
  {
    $this->evalData = $evalData;
  }
  /**
   * @return NlpSemanticParsingAnnotationEvalData
   */
  public function getEvalData()
  {
    return $this->evalData;
  }
  /**
   * @param bool
   */
  public function setIsAnnotatedFromText($isAnnotatedFromText)
  {
    $this->isAnnotatedFromText = $isAnnotatedFromText;
  }
  /**
   * @return bool
   */
  public function getIsAnnotatedFromText()
  {
    return $this->isAnnotatedFromText;
  }
  /**
   * @param string
   */
  public function setNormalizedText($normalizedText)
  {
    $this->normalizedText = $normalizedText;
  }
  /**
   * @return string
   */
  public function getNormalizedText()
  {
    return $this->normalizedText;
  }
  /**
   * @param string
   */
  public function setOriginalText($originalText)
  {
    $this->originalText = $originalText;
  }
  /**
   * @return string
   */
  public function getOriginalText()
  {
    return $this->originalText;
  }
  /**
   * @param string
   */
  public function setRawText($rawText)
  {
    $this->rawText = $rawText;
  }
  /**
   * @return string
   */
  public function getRawText()
  {
    return $this->rawText;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(NlpSemanticParsingModelsCommunicationPhoneType::class, 'Google_Service_Contentwarehouse_NlpSemanticParsingModelsCommunicationPhoneType');
