<?php
/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Custom_Learndash
 * @subpackage Custom_Learndash/public
 * @author     Wbcom Designs <admin@wbcomdesigns.com>
 */
class Ld_Dashboard_Register_Topic_Group_Fields {
	public function __construct() {
		if ( function_exists( 'acf_add_local_field_group' ) ) :
			$course_label = LearnDash_Custom_Label::get_label( 'course' );
			$lesson_label = LearnDash_Custom_Label::get_label( 'lesson' );
			$topic_label  = LearnDash_Custom_Label::get_label( 'topic' );
			$fields       = array(
				array(
					'key'                         => 'field_61b72a9cc2d3a',
					'label'                       => sprintf( esc_html__( '%s Title', 'ld-dashboard' ), $topic_label ),
					'name'                        => 'ldd_post_title',
					'type'                        => 'text',
					'instructions'                => '',
					'required'                    => 1,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-form ld-dashboard-form-post-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'readonly'                    => 0,
					'default_value'               => '',
					'placeholder'                 => '',
					'prepend'                     => '',
					'append'                      => '',
					'maxlength'                   => '',
				),
				array(
					'key'                         => 'field_61b72abfc2d3b',
					'label'                       => sprintf( esc_html__( '%s Status', 'ld-dashboard' ), $topic_label ),
					'name'                        => 'ldd_topic_status',
					'type'                        => 'radio',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-form ld-dashboard-form-post-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'choices'                     => array(
						'publish' => __( 'Published', 'ld-dashboard' ),
						'pending' => __( 'Pending', 'ld-dashboard' ),
						'draft'   => __( 'Draft', 'ld-dashboard' ),
					),
					'allow_null'                  => 0,
					'other_choice'                => 0,
					'default_value'               => '',
					'layout'                      => 'horizontal',
					'return_format'               => 'value',
					'save_other_choice'           => 0,
				),
				array(
					'key'                         => 'field_61b72fe6c2d3c',
					'label'                       => sprintf( esc_html__( '%s Content', 'ld-dashboard' ), $topic_label ),
					'name'                        => 'ldd_post_content',
					'type'                        => 'wysiwyg',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-form ld-dashboard-form-post-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'readonly'                    => 0,
					'default_value'               => '',
					'tabs'                        => 'all',
					'toolbar'                     => 'full',
					'media_upload'                => 1,
				),
				array(
					'key'               => 'field_61lloiu654xd',
					'label'             => esc_html__( 'Featured Image', 'ld-dashboard' ),
					'name'              => '_thumbnail_id',
					'type'              => 'image',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form add-course-featured-img ld-dashboard-form-post-data-tab',
						'id'    => '',
					),
					'return_format'     => 'id',
					'preview_size'      => 'medium',
					'library'           => 'uploadedTo',
					'min_width'         => '',
					'min_height'        => '',
					'min_size'          => '',
					'max_width'         => '',
					'max_height'        => '',
					'max_size'          => '',
					'mime_types'        => '',
				),
				array(
					'key'                         => 'field_61b73007c2d3d',
					'label'                       => sprintf( esc_html__( '%s Materials', 'ld-dashboard' ), $topic_label ),
					'name'                        => 'sfwd-topic_topic_materials_enabled_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => sprintf( esc_html__( 'Any content added below is displayed on the %s page', 'ld-dashboard' ), strtolower( $topic_label ) ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61b7302ac2d3e',
					'label'                       => esc_html__( 'Materials', 'ld-dashboard' ),
					'name'                        => 'sfwd-topic_topic_materials_cld',
					'type'                        => 'wysiwyg',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b73007c2d3d',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'default_value'               => '',
					'tabs'                        => 'all',
					'toolbar'                     => 'full',
					'media_upload'                => 1,
					'delay'                       => 0,
				),
				array(
					'key'                         => 'field_61b7304bc2d3f',
					'label'                       => esc_html__( 'Video Progression', 'ld-dashboard' ),
					'name'                        => 'sfwd-topic_lesson_video_enabled_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b736d9c2d49',
								'operator' => '!=',
								'value'    => '1',
							),
							array(
								'field'    => 'field_61b738f0c2d52',
								'operator' => '!=',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => esc_html__( 'The below video is tied to course progression', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61b7308ec2d40',
					'label'                       => esc_html__( 'Video URL', 'ld-dashboard' ),
					'name'                        => 'sfwd-topic_lesson_video_url_cld',
					'type'                        => 'url',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b7304bc2d3f',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'default_value'               => '',
					'placeholder'                 => '',
				),
				array(
					'key'                         => 'field_61b73442c2d41',
					'label'                       => esc_html__( 'Display Timing', 'ld-dashboard' ),
					'name'                        => 'sfwd-topic_lesson_video_shown_cld',
					'type'                        => 'radio',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b7304bc2d3f',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'choices'                     => array(
						'BEFORE' => sprintf( esc_html__( 'Before completed sub-steps (The video will be shown and must be fully watched before the user can access the %s associated steps.)', 'ld-dashboard' ), strtolower( $topic_label ) ),
						'AFTER'  => sprintf( esc_html__( 'After completing sub-steps (The video will be visible after the user has completed the %1$s associated steps. The full video must be watched in order to complete the %2$s.)', 'ld-dashboard' ), strtolower( $topic_label ), strtolower( $topic_label ) ),
					),
					'allow_null'                  => 0,
					'other_choice'                => 0,
					'default_value'               => '',
					'layout'                      => 'vertical',
					'return_format'               => 'value',
					'save_other_choice'           => 0,
				),
				array(
					'key'                         => 'field_61b73475c2d42',
					'label'                       => sprintf( esc_html__( '%s Auto-Completion', 'ld-dashboard' ), $topic_label ),
					'name'                        => 'sfwd-topic_lesson_video_auto_complete_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b73442c2d41',
								'operator' => '==',
								'value'    => 'AFTER',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 1,
					'message'                     => '',
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61b734b3c2d43',
					'label'                       => esc_html__( 'Completion Delay', 'ld-dashboard' ),
					'name'                        => 'sfwd-topic_lesson_video_auto_complete_delay_cld',
					'type'                        => 'number',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b73442c2d41',
								'operator' => '==',
								'value'    => 'AFTER',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-topic-com-delay custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'readonly'                    => 0,
					'default_value'               => '',
					'placeholder'                 => '',
					'prepend'                     => '',
					'append'                      => 'seconds',
					'min'                         => '',
					'max'                         => '',
					'step'                        => '',
				),
				array(
					'key'                         => 'field_61b734e5c2d44',
					'label'                       => esc_html__( 'Mark Complete Button', 'ld-dashboard' ),
					'name'                        => 'sfwd-topic_lesson_video_show_complete_button_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b73442c2d41',
								'operator' => '==',
								'value'    => 'AFTER',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => '',
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61b73512c2d45',
					'label'                       => esc_html__( 'Autostart', 'ld-dashboard' ),
					'name'                        => 'sfwd-topic_lesson_video_auto_start_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b7304bc2d3f',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => esc_html__( 'Enable Autostart', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61b73544c2d46',
					'label'                       => esc_html__( 'Video Controls Display', 'ld-dashboard' ),
					'name'                        => 'sfwd-topic_lesson_video_show_controls_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b7304bc2d3f',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 1,
					'message'                     => esc_html__( 'Enable Video Controls Display.', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61b7366dc2d47',
					'label'                       => esc_html__( 'Text Video Pause on Window Unfocused', 'ld-dashboard' ),
					'name'                        => 'sfwd-topic_lesson_video_focus_pause_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b7304bc2d3f',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => esc_html__( 'Enable Text Video Pause on Window Unfocused', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61b736a9c2d48',
					'label'                       => esc_html__( 'Video Resume', 'ld-dashboard' ),
					'name'                        => 'sfwd-topic_lesson_video_track_time_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b7304bc2d3f',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => __( 'Enable Video Resume', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61b736d9c2d49',
					'label'                       => esc_html__( 'Assignment Uploads', 'ld-dashboard' ),
					'name'                        => 'sfwd-topic_lesson_assignment_upload_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b7304bc2d3f',
								'operator' => '!=',
								'value'    => '1',
							),
							array(
								'field'    => 'field_61b738f0c2d52',
								'operator' => '!=',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => esc_html__( 'Enable Assignment Uploads', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61b737e1c2d4g',
					'label'                       => esc_html__( 'Enable Points', 'ld-dashboard' ),
					'name'                        => 'sfwd-topic_lesson_assignment_points_enabled_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b736d9c2d49',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => __( 'Award points for submitting assignments', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61b737e1c2d4h',
					'label'                       => esc_html__( 'Points', 'ld-dashboard' ),
					'name'                        => 'sfwd-topic_lesson_assignment_points_amount_cld',
					'type'                        => 'number',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b737e1c2d4g',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => __( 'available point(s)', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61b737e1c2d4f',
					'label'                       => esc_html__( 'Grading Type', 'ld-dashboard' ),
					'name'                        => 'sfwd-topic_auto_approve_assignment_cld',
					'type'                        => 'radio',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b736d9c2d49',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'choices'                     => array(
						'on'  => esc_html__( 'Auto-approve (No grading or approval needed. The assignment will be automatically approved and full points will be awarded.)', 'ld-dashboard' ),
						'off' => sprintf( esc_html__( 'Manually grade (Admin or Group leader approval and grading required. The %s cannot be completed until the assignment is approved.)', 'ld-dashboard' ), strtolower( $topic_label ) ),
					),
					'allow_null'                  => 0,
					'other_choice'                => 0,
					'default_value'               => '',
					'layout'                      => 'vertical',
					'return_format'               => 'value',
					'save_other_choice'           => 0,
				),
				array(
					'key'                         => 'field_61b738f0c2d52',
					'label'                       => sprintf( esc_html__( '%s Timer', 'ld-dashboard' ), $topic_label ),
					'name'                        => 'sfwd-topic_forced_lesson_time_enabled_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b7304bc2d3f',
								'operator' => '!=',
								'value'    => '1',
							),
							array(
								'field'    => 'field_61b736d9c2d49',
								'operator' => '!=',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => sprintf( esc_html__( 'The %s cannot be marked as completed until the set time has elapsed.', 'ld-dashboard' ), strtolower( $topic_label ) ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61b73922c2d54',
					'label'                       => esc_html__( 'Time Picker', 'ld-dashboard' ),
					'name'                        => 'sfwd-topic_forced_lesson_time_cld',
					'type'                        => 'time_picker',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b738f0c2d52',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'display_format'              => 'H:i:s',
					'return_format'               => 'H:i:s',
					'first_day'                   => 1,
				),
				array(
					'key'                         => 'field_61b73957c2d55',
					'label'                       => sprintf( esc_html__( 'Associated %s', 'ld-dashboard' ), $course_label ),
					'name'                        => 'sfwd-topic_course_cld',
					'type'                        => 'post_object',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form ld-dashboard-form-settings-data-tab ldd-course-select2',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'post_type'                   => array(
						0 => 'sfwd-courses',
					),
					'taxonomy'                    => '',
					'allow_null'                  => 0,
					'multiple'                    => 0,
					'return_format'               => 'id',
					'ui'                          => 1,
				),
				array(
					'key'                         => 'field_61b7398cc2d56',
					'label'                       => sprintf( esc_html__( 'Associated %s', 'ld-dashboard' ), $lesson_label ),
					'name'                        => 'sfwd-topic_lesson_cldd',
					'type'                        => 'text',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form ld-dashboard-form-settings-data-tab ldd-lesson-input',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'readonly'                    => 0,
					'default_value'               => '',
					'placeholder'                 => '',
					'prepend'                     => '',
					'append'                      => '',
					'maxlength'                   => '',
				),
				array(
					'key'               => 'field_6215e03fe3d2711',
					'label'             => sprintf( esc_html__( '%s Category', 'ld-dashboard' ), $topic_label ),
					'name'              => 'ldd_topic_category',
					'type'              => 'taxonomy',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-form ld-dashboard-form-post-data-tab',
						'id'    => '',
					),
					'taxonomy'          => 'ld_topic_category',
					'field_type'        => 'select',
					'allow_null'        => 0,
					'add_term'          => 0,
					'save_terms'        => 1,
					'load_terms'        => 0,
					'return_format'     => 'id',
					'multiple'          => 0,
				),
				array(
					'key'               => 'field_621dbf8aaaaaa',
					'label'             => sprintf( esc_html__( '%s Tags', 'ld-dashboard' ), $topic_label ),
					'name'              => 'ldd_topic_tags',
					'type'              => 'taxonomy',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-topic-form custom-learndash-course-form ld-dashboard-form-post-data-tab',
						'id'    => '',
					),
					'taxonomy'          => 'ld_topic_tag',
					'field_type'        => 'multi_select',
					'allow_null'        => 0,
					'add_term'          => 1,
					'save_terms'        => 1,
					'load_terms'        => 0,
					'return_format'     => 'id',
					'multiple'          => 0,
				),
			);

			// Add/Edit topic form fields for frontend.
			$fields = apply_filters( 'ld_dashboard_topic_form_fields', $fields );

			// Register topic form field for frontend.
			acf_add_local_field_group(
				array(
					'key'                   => 'topic-field-group',
					'title'                 => esc_html__( 'Topic Form', 'ld-dashboard' ),
					'fields'                => $fields,
					'location'              => array(
						array(
							array(
								'param'    => 'page',
								'operator' => '==',
								'value'    => Ld_Dashboard_Functions::instance()->ld_dashboard_get_page_id( 'dashboard' ),
							),
							array(
								'param'    => 'current_user',
								'operator' => '==',
								'value'    => 'viewing_front',
							),
						),
					),
					'menu_order'            => 0,
					'position'              => 'normal',
					'style'                 => 'default',
					'label_placement'       => 'top',
					'instruction_placement' => 'label',
					'hide_on_screen'        => '',
					'active'                => true,
					'description'           => '',
				)
			);

			endif;
	}
}
