<?php
/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Custom_Learndash
 * @subpackage Custom_Learndash/public
 * @author     Wbcom Designs <admin@wbcomdesigns.com>
 */
class Ld_Dashboard_Register_Quiz_Group_Fields {
	public function __construct() {
		if ( function_exists( 'acf_add_local_field_group' ) ) :
			$course_label = LearnDash_Custom_Label::get_label( 'course' );
			$lesson_label = LearnDash_Custom_Label::get_label( 'lesson' );
			$quiz_label   = LearnDash_Custom_Label::get_label( 'quiz' );
			$fields       = array(
				array(
					'key'                         => 'field_61d7fd69a6576',
					'label'                       => sprintf( esc_html__( '%s Title', 'ld-dashboard' ), $quiz_label ),
					'name'                        => 'ldd_post_title',
					'type'                        => 'text',
					'instructions'                => '',
					'required'                    => 1,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-post-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'readonly'                    => 0,
					'default_value'               => '',
					'placeholder'                 => '',
					'prepend'                     => '',
					'append'                      => '',
					'maxlength'                   => '',
				),
				array(
					'key'                         => 'field_61d7fd8ba6577',
					'label'                       => sprintf( esc_html__( '%s Content', 'ld-dashboard' ), $quiz_label ),
					'name'                        => 'ldd_post_content',
					'type'                        => 'wysiwyg',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-post-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'readonly'                    => 0,
					'default_value'               => '',
					'tabs'                        => 'all',
					'toolbar'                     => 'full',
					'media_upload'                => 1,
				),
				array(
					'key'               => 'field_61lkjhgf321',
					'label'             => esc_html__( 'Featured Image', 'ld-dashboard' ),
					'name'              => '_thumbnail_id',
					'type'              => 'image',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form add-course-featured-img ld-dashboard-form-post-data-tab',
						'id'    => '',
					),
					'return_format'     => 'id',
					'preview_size'      => 'medium',
					'library'           => 'uploadedTo',
					'min_width'         => '',
					'min_height'        => '',
					'min_size'          => '',
					'max_width'         => '',
					'max_height'        => '',
					'max_size'          => '',
					'mime_types'        => '',
				),
				array(
					'key'                         => 'field_61d7fda3a6578',
					'label'                       => sprintf( esc_html__( 'Associated %s', 'ld-dashboard' ), $course_label ),
					'name'                        => 'sfwd-quiz_course_cld',
					'type'                        => 'post_object',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab ldd-course-select2',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'post_type'                   => array(
						0 => 'sfwd-courses',
					),
					'taxonomy'                    => '',
					'allow_null'                  => 0,
					'multiple'                    => 0,
					'return_format'               => 'id',
					'ui'                          => 1,
				),
				array(
					'key'                         => 'field_61d7fdc7a6579',
					'label'                       => sprintf( esc_html__( 'Associated %s', 'ld-dashboard' ), $lesson_label ),
					'name'                        => 'sfwd-quiz_lesson_cldd',
					'type'                        => 'text',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab ldd-lesson-input',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'readonly'                    => 0,
					'default_value'               => '',
					'placeholder'                 => '',
					'prepend'                     => '',
					'append'                      => '',
					'maxlength'                   => '',
				),
				array(
					'key'                         => 'field_61d7fdffa657b',
					'label'                       => esc_html__( 'Passing Score', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_passingpercentage_cld',
					'type'                        => 'number',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'readonly'                    => 0,
					'default_value'               => 80,
					'placeholder'                 => '',
					'prepend'                     => '',
					'append'                      => '%',
					'min'                         => '',
					'max'                         => '',
					'step'                        => '',
				),
				array(
					'key'                         => 'field_61d7fe28a657c',
					'label'                       => sprintf( esc_html__( '%s Certificate', 'ld-dashboard' ), $quiz_label ),
					'name'                        => 'sfwd-quiz_certificate_cld',
					'type'                        => 'post_object',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'post_type'                   => array(
						0 => 'sfwd-certificates',
					),
					'taxonomy'                    => '',
					'allow_null'                  => 0,
					'multiple'                    => 0,
					'return_format'               => 'id',
					'ui'                          => 1,
				),
				array(
					'key'                         => 'field_61d7fe3ea657d',
					'label'                       => esc_html__( 'Certificate Awarded for', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_threshold_cld',
					'type'                        => 'number',
					'instructions'                => esc_html__( 'Set the score needed to receive a certificate. This can be different from the "Passing Score".', 'ld-dashboard' ),
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d7fe28a657c',
								'operator' => '!=empty',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'readonly'                    => 0,
					'default_value'               => '',
					'placeholder'                 => '',
					'prepend'                     => '',
					'append'                      => '% score',
					'min'                         => '',
					'max'                         => '',
					'step'                        => '',
				),
				array(
					'key'                         => 'field_61d8070ea657e',
					'label'                       => sprintf( esc_html__( 'Restrict %s Retakes', 'ld-dashboard' ), $quiz_label ),
					'name'                        => 'sfwd-quiz_retry_restrictions_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => esc_html__( 'Enable/Disable', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61d807e9a657f',
					'label'                       => esc_html__( 'Number of Retries Allowed', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_repeats_cld',
					'type'                        => 'number',
					'instructions'                => esc_html__( 'You must input a whole number value or leave blank to default to 0.', 'ld-dashboard' ),
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d8070ea657e',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'readonly'                    => 0,
					'default_value'               => '',
					'placeholder'                 => '',
					'prepend'                     => '',
					'append'                      => '',
					'min'                         => '',
					'max'                         => '',
					'step'                        => '',
				),
				array(
					'key'                         => 'field_61d80813a6580',
					'label'                       => esc_html__( 'Retries Applicable to', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_quizRunOnceType_cld',
					'type'                        => 'select',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d8070ea657e',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'choices'                     => array(
						1 => esc_html__( 'All Users', 'ld-dashboard' ),
						2 => esc_html__( 'Registered Users Only', 'ld-dashboard' ),
						3 => esc_html__( 'Anonymous User Only', 'ld-dashboard' ),
					),
					'default_value'               => false,
					'allow_null'                  => 0,
					'multiple'                    => 0,
					'ui'                          => 0,
					'return_format'               => 'value',
					'ajax'                        => 0,
					'placeholder'                 => '',
				),
				array(
					'key'                         => 'field_61d8083fa6581',
					'label'                       => sprintf( esc_html__( '%s Completion', 'ld-dashboard' ), LearnDash_Custom_Label::get_label( 'question' ) ),
					'name'                        => 'sfwd-quiz_forcingQuestionSolve_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => sprintf( esc_html__( 'All %s required to complete', 'ld-dashboard' ), LearnDash_Custom_Label::get_label( 'questions' ) ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61deee122',
					'label'                       => esc_html__( 'Time Limit', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_quiz_time_limit_enabled_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => esc_html__( 'Enable/Disable', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),

				array(
					'key'               => 'field_623849ad640c2',
					'label'             => esc_html__( 'Automatically Submit After', 'ld-dashboard' ),
					'name'              => 'sfwd-quiz_timeLimit_cld',
					'type'              => 'group',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_61deee122',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab ld-dashboard-quiz-time-limit-field ld-dashboard-group-field',
						'id'    => '',
					),
					'layout'            => 'table',
				),
				array(
					'key'               => 'field_62384a65a2cfa',
					'label'             => esc_html__( 'Hour', 'ld-dashboard' ),
					'name'              => 'quiz_timeLimit_timer_hr',
					'type'              => 'number',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_61deee122',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab ld-dashboard-quiz-time-limit-field-timer ld-dashboard-group-field-single ldd-hide-label',
						'id'    => '',
					),
					'default_value'     => '',
					'placeholder'       => '',
					'prepend'           => '',
					'append'            => 'hr',
					'min'               => 0,
					'max'               => '',
					'step'              => '',
				),
				array(
					'key'               => 'field_62384a9ea2cfb',
					'label'             => esc_html__( 'Minute', 'ld-dashboard' ),
					'name'              => 'quiz_timeLimit_timer_min',
					'type'              => 'number',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_61deee122',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab ld-dashboard-quiz-time-limit-field-timer ld-dashboard-group-field-single ldd-hide-label',
						'id'    => '',
					),
					'default_value'     => '',
					'placeholder'       => '',
					'prepend'           => '',
					'append'            => 'min',
					'min'               => 0,
					'max'               => '',
					'step'              => '',
				),
				array(
					'key'               => 'field_62384aa9a2cfc',
					'label'             => esc_html__( 'Second', 'ld-dashboard' ),
					'name'              => 'quiz_timeLimit_timer_sec',
					'type'              => 'number',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_61deee122',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab ld-dashboard-quiz-time-limit-field-timer ld-dashboard-group-field-single ldd-hide-label',
						'id'    => '',
					),
					'default_value'     => '',
					'placeholder'       => '',
					'prepend'           => '',
					'append'            => 'sec',
					'min'               => 0,
					'max'               => '',
					'step'              => '',
				),
				array(
					'key'                         => 'field_61d8089d0be2a',
					'label'                       => sprintf( esc_html__( '%s Materials', 'ld-dashboard' ), $quiz_label ),
					'name'                        => 'sfwd-quiz_quiz_materials_enabled_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => sprintf( esc_html__( 'List and display support materials for the %1$s. This is visible to any user having access to the %2$s.', 'ld-dashboard' ), strtolower( LearnDash_Custom_Label::get_label( 'quiz' ) ), strtolower( LearnDash_Custom_Label::get_label( 'quiz' ) ) ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61d808b30be2b',
					'label'                       => sprintf( esc_html__( '%s Material Content', 'ld-dashboard' ), $quiz_label ),
					'name'                        => 'sfwd-quiz_quiz_materials_cld',
					'type'                        => 'wysiwyg',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d8089d0be2a',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab ldd-hide-label',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'default_value'               => '',
					'tabs'                        => 'all',
					'toolbar'                     => 'full',
					'media_upload'                => 1,
					'delay'                       => 0,
				),
				array(
					'key'                         => 'field_61d808e00be2c',
					'label'                       => sprintf( esc_html__( '%s Display', 'ld-dashboard' ), LearnDash_Custom_Label::get_label( 'question' ) ),
					'name'                        => 'sfwd-quiz_quizModus_cld',
					'type'                        => 'select',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'choices'                     => array(
						0 => sprintf( esc_html__( 'One %s at a time', 'ld-dashboard' ), strtolower( LearnDash_Custom_Label::get_label( 'question' ) ) ),
						3 => sprintf( esc_html__( 'All %s at once (or paginated)', 'ld-dashboard' ), strtolower( LearnDash_Custom_Label::get_label( 'questions' ) ) ),
					),
					'default_value'               => false,
					'allow_null'                  => 0,
					'multiple'                    => 0,
					'ui'                          => 0,
					'return_format'               => 'value',
					'ajax'                        => 0,
					'placeholder'                 => '',
				),
				array(
					'key'                         => 'field_61d809610be2d',
					'label'                       => esc_html__( 'Display result position', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_quizModus_single_feedback_cld',
					'type'                        => 'radio',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d808e00be2c',
								'operator' => '==',
								'value'    => '0',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab ldd-hide-label',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'choices'                     => array(
						'end'  => esc_html__( 'Display results at the end only', 'ld-dashboard' ),
						'each' => esc_html__( 'Display results after each submitted answer', 'ld-dashboard' ),
					),
					'allow_null'                  => 0,
					'other_choice'                => 0,
					'default_value'               => '',
					'layout'                      => 'vertical',
					'return_format'               => 'value',
					'save_other_choice'           => 0,
				),
				array(
					'key'                         => 'field_61d809930be2e',
					'label'                       => sprintf( esc_html__( '%s per page', 'ld-dashboard' ), LearnDash_Custom_Label::get_label( 'questions' ) ),
					'name'                        => 'sfwd-quiz_quizModus_multiple_questionsPerPage_cld',
					'type'                        => 'number',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d808e00be2c',
								'operator' => '==',
								'value'    => '3',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab ldd-hide-label',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'readonly'                    => 0,
					'default_value'               => '',
					'placeholder'                 => '',
					'prepend'                     => '',
					'append'                      => sprintf( esc_html__( '%s per page', 'ld-dashboard' ), strtolower( LearnDash_Custom_Label::get_label( 'questions' ) ) ),
					'min'                         => '',
					'max'                         => '',
					'step'                        => '',
				),
				array(
					'key'                         => 'field_61d809be0be2f',
					'label'                       => esc_html__( 'Display Back button', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_quizModus_single_back_button_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d809610be2d',
								'operator' => '==',
								'value'    => 'end',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => esc_html__( 'Enable back button.', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61d80a03926d0',
					'label'                       => sprintf( esc_html__( '%s Overview Table', 'ld-dashboard' ), LearnDash_Custom_Label::get_label( 'question' ) ),
					'name'                        => 'sfwd-quiz_showReviewQuestion_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => sprintf( esc_html__( 'An overview table will be shown for all %s.', 'ld-dashboard' ), strtolower( LearnDash_Custom_Label::get_label( 'questions' ) ) ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),

				array(
					'key'                         => 'field_61d80a47926d1',
					'label'                       => sprintf( esc_html__( '%s Summary', 'ld-dashboard' ), LearnDash_Custom_Label::get_label( 'quiz' ) ),
					'name'                        => 'sfwd-quiz_quizSummaryHide_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d80a03926d0',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => esc_html__( 'Display a summary table before submission', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),

				array(
					'key'                         => 'field_61d80a47926d2',
					'label'                       => sprintf( esc_html__( 'Skip %s', 'ld-dashboard' ), LearnDash_Custom_Label::get_label( 'question' ) ),
					'name'                        => 'sfwd-quiz_skipQuestionDisabled_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d80a03926d0',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => '',
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),

				array(
					'key'                         => 'field_61d80a03926c1',
					'label'                       => sprintf( esc_html__( 'Custom %s Ordering', 'ld-dashboard' ), LearnDash_Custom_Label::get_label( 'question' ) ),
					'name'                        => 'sfwd-quiz_custom_sorting_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => sprintf( esc_html__( 'Enable custom ordering for %s', 'ld-dashboard' ), strtolower( LearnDash_Custom_Label::get_label( 'questions' ) ) ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61d80a47926c2',
					'label'                       => esc_html__( 'Randomize Order', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_randomize_order_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d80a03926c1',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => sprintf( esc_html__( 'Enable random order for %s', 'ld-dashboard' ), strtolower( LearnDash_Custom_Label::get_label( 'question' ) ) ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61d80a66926c3',
					'label'                       => esc_html__( 'Randomize order type', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_showMaxQuestion_cld',
					'type'                        => 'radio',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d80a47926c2',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form custom-learndash-course-sub-form ld-dashboard-form-settings-data-tab ldd-hide-label',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'choices'                     => array(
						'display_all_questions'       => sprintf( esc_html__( 'Display all %s', 'ld-dashboard' ), LearnDash_Custom_Label::get_label( 'questions' ) ),
						'display_subset_of_questions' => sprintf( esc_html__( 'Display subset of %s', 'ld-dashboard' ), LearnDash_Custom_Label::get_label( 'questions' ) ),
					),
					'allow_null'                  => 0,
					'other_choice'                => 0,
					'default_value'               => '',
					'layout'                      => 'vertical',
					'return_format'               => 'value',
					'save_other_choice'           => 0,
				),
				array(
					'key'                         => 'field_61d80b24926c4',
					'label'                       => sprintf( esc_html__( 'Number of %s in subset', 'ld-dashboard' ), LearnDash_Custom_Label::get_label( 'questions' ) ),
					'name'                        => 'sfwd-quiz_showMaxQuestionValue_cld',
					'type'                        => 'number',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d80a66926c3',
								'operator' => '==',
								'value'    => 'display_subset_of_questions',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-sub-form custom-learndash-course-form ld-dashboard-form-settings-data-tab ldd-hide-label',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'readonly'                    => 0,
					'default_value'               => 0,
					'placeholder'                 => '',
					'prepend'                     => '',
					'append'                      => sprintf( esc_html__( 'out of total %s', 'ld-dashboard' ), LearnDash_Custom_Label::get_label( 'questions' ) ),
					'min'                         => '',
					'max'                         => '',
					'step'                        => '',
				),
				array(
					'key'                         => 'field_61d80b4d926c5',
					'label'                       => sprintf( esc_html__( 'Additional %s Options', 'ld-dashboard' ), LearnDash_Custom_Label::get_label( 'question' ) ),
					'name'                        => 'sfwd-quiz_custom_question_elements_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => esc_html__( 'Enable additional options.', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61d80b61926c6',
					'label'                       => esc_html__( 'Randomize Answers', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_randomize_answers_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d80b4d926c5',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-sub-form custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => sprintf( esc_html__( 'Answer display will be randomized within any given %s', 'ld-dashboard' ), strtolower( LearnDash_Custom_Label::get_label( 'question' ) ) ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61d80b88926c7',
					'label'                       => esc_html__( 'Leaderboard', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_toplistActivated_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => esc_html__( 'Enable leaderboard display.', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61d80ba2926c8',
					'label'                       => esc_html__( 'Who can apply?', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_toplistDataAddPermissions_cld',
					'type'                        => 'select',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d80b88926c7',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-sub-form custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'choices'                     => array(
						1 => 'All User',
						2 => 'Registered user only',
						3 => 'Anonymous User Only',
					),
					'default_value'               => false,
					'allow_null'                  => 0,
					'multiple'                    => 0,
					'ui'                          => 0,
					'return_format'               => 'value',
					'ajax'                        => 0,
					'placeholder'                 => '',
				),
				array(
					'key'                         => 'field_61d80bc2926c9',
					'label'                       => esc_html__( 'Multiple Applications per user', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_toplistDataAddMultiple_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d80b88926c7',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-sub-form custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => esc_html__( 'Users can apply more than once to the leaderboard', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61d80be2926ca',
					'label'                       => esc_html__( 'Re-apply after', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_toplistDataAddBlock_cld',
					'type'                        => 'number',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d80bc2926c9',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-sub-form custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'readonly'                    => 0,
					'default_value'               => 0,
					'placeholder'                 => '',
					'prepend'                     => '',
					'append'                      => 'minutes',
					'min'                         => '',
					'max'                         => '',
					'step'                        => '',
				),
				array(
					'key'                         => 'field_61d80c05926cb',
					'label'                       => esc_html__( 'Automatic user entry', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_toplistDataAddAutomatic_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d80b88926c7',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-sub-form custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => esc_html__( 'Enable/Disable', 'ld-dashboard' ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61d80c21926cc',
					'label'                       => esc_html__( 'Number of displayed entries', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_toplistDataShowLimit_cld',
					'type'                        => 'number',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d80b88926c7',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-sub-form custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'readonly'                    => 0,
					'default_value'               => '',
					'placeholder'                 => '',
					'prepend'                     => '',
					'append'                      => '',
					'min'                         => '',
					'max'                         => '',
					'step'                        => '',
				),
				array(
					'key'                         => 'field_61d80c37926cd',
					'label'                       => esc_html__( 'Sort list by?', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_toplistDataSort_cld',
					'type'                        => 'select',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d80b88926c7',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-sub-form custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'choices'                     => array(
						1 => 'Best User',
						2 => 'Newest Entry',
						3 => 'Oldest Entry',
					),
					'default_value'               => false,
					'allow_null'                  => 0,
					'multiple'                    => 0,
					'ui'                          => 0,
					'return_format'               => 'value',
					'ajax'                        => 0,
					'placeholder'                 => '',
				),
				array(
					'key'                         => 'field_61d80c5a926ce',
					'label'                       => sprintf( esc_html__( 'Display on %s results page', 'ld-dashboard' ), $quiz_label ),
					'name'                        => 'sfwd-quiz_toplistDataShowIn_enabled_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d80b88926c7',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-sub-form custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'message'                     => 'Enable/Disable',
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_61d80c76926cf',
					'label'                       => esc_html__( 'Leaderboard position', 'ld-dashboard' ),
					'name'                        => 'sfwd-quiz_toplistDataShowIn',
					'type'                        => 'radio',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61d80c5a926ce',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-sub-form custom-learndash-course-form ld-dashboard-form-settings-data-tab ldd-hide-label',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'choices'                     => array(
						1 => 'Below the result text',
						2 => 'In a button',
					),
					'allow_null'                  => 0,
					'other_choice'                => 0,
					'default_value'               => '',
					'layout'                      => 'vertical',
					'return_format'               => 'value',
					'save_other_choice'           => 0,
				),
				array(
					'key'               => 'field_620239860eee2',
					'label'             => sprintf( esc_html__( '%s Builder', 'ld-dashboard' ), $quiz_label ),
					'name'              => 'ldd_builder',
					'type'              => 'text',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-course-builder-wrapper',
						'id'    => '',
					),
					'default_value'     => '',
					'placeholder'       => '',
					'prepend'           => '',
					'append'            => '',
					'maxlength'         => '',
				),
			);
			// Add/Edit quiz form fields for frontend.
			$fields = apply_filters( 'ld_dashboard_quiz_form_fields', $fields );

			// Register quiz form fields for frontend.
			acf_add_local_field_group(
				array(
					'key'                   => 'quizz-field-group',
					'title'                 => esc_html__( 'Quiz test', 'ld-dashboard' ),
					'fields'                => $fields,
					'location'              => array(
						array(
							array(
								'param'    => 'page',
								'operator' => '==',
								'value'    => Ld_Dashboard_Functions::instance()->ld_dashboard_get_page_id( 'dashboard' ),
							),
							array(
								'param'    => 'current_user',
								'operator' => '==',
								'value'    => 'viewing_front',
							),
						),
					),
					'menu_order'            => 0,
					'position'              => 'normal',
					'style'                 => 'default',
					'label_placement'       => 'top',
					'instruction_placement' => 'label',
					'hide_on_screen'        => '',
					'active'                => true,
					'description'           => '',
				)
			);
			endif;
	}
}


