<?php
/*
Plugin Name: 2Checkout for LearnDash  
Plugin URI: http://www.learndash.com
Description: 2Checkout payment gateway for LearnDash LMS. 
Version: 1.1.1.1
Author: نوین وردپرس
Author URI: https://wpnovin.com/
*/

define('LDCO_LEARNDASH_PLUGIN_FILE', 'sfwd-lms/sfwd_lms.php');
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
include_once( plugin_dir_path( __FILE__ ) . 'checkout_process.php' );

if(is_plugin_active(LDCO_LEARNDASH_PLUGIN_FILE))
{
	add_action('admin_menu', 'learndash_payment_button_2checkout_menu', 1100);
	add_filter('learndash_payment_button', 'learndash_payment_button_2checkout',1,2);
	add_action( 'plugins_loaded', "learndash_2checkout_i18ize" );
}
function learndash_2checkout_i18ize() {
	load_plugin_textdomain( 'learndash_2checkout', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' ); 
}
function learndash_payment_button_2checkout_menu() {
	add_submenu_page("edit.php?post_type=sfwd-courses", __("2Checkout Settings","learndash_2checkout"), __("2Checkout Settings","learndash_2checkout"), 'manage_options','admin.php?page=learndash-2checkout-settings', 'learndash_payment_button_2checkout_menupage');
	add_submenu_page("learndash-lms-non-existant", __("2Checkout Settings", "learndash_2checkout"), __("2Checkout Settings", "learndash_2checkout"), "manage_options", "learndash-2checkout-settings", "learndash_payment_button_2checkout_menupage");
}

function learndash_2checkout_admin_tabs($admin_tabs) {
	$admin_tabs["2checkout"] = array(
									"link"	=>	'admin.php?page=learndash-2checkout-settings',
									"name"	=>	__("2Checkout Settings","learndash_2checkout"),
									"id"	=>	"admin_page_learndash-2checkout-settings",
									"menu_link"	=> 	"edit.php?post_type=sfwd-courses&page=sfwd-lms_sfwd_lms.php_post_type_sfwd-courses",
								);
	return $admin_tabs;
}
add_filter("learndash_admin_tabs", "learndash_2checkout_admin_tabs", 1, 1);

function learndash_2checkout_learndash_admin_tabs_on_page($admin_tabs_on_page, $admin_tabs, $current_page_id) {
	$admin_tabs_on_page["admin_page_learndash-2checkout-settings"] = array_merge($admin_tabs_on_page["sfwd-courses_page_sfwd-lms_sfwd_lms_post_type_sfwd-courses"], (array) $admin_tabs_on_page["admin_page_learndash-2checkout-settings"]);

	foreach ($admin_tabs as $key => $value) {
		if($value["id"] == $current_page_id && $value["menu_link"] == "edit.php?post_type=sfwd-courses&page=sfwd-lms_sfwd_lms.php_post_type_sfwd-courses")
		{
			$admin_tabs_on_page[$current_page_id][] = "2checkout";
			return $admin_tabs_on_page;
		}
	}
	return $admin_tabs_on_page;
}
add_filter("learndash_admin_tabs_on_page", "learndash_2checkout_learndash_admin_tabs_on_page", 3, 3);
function learndash_payment_button_2checkout_menupage() {
   //must check that the user has the required capability 
    if (!current_user_can('manage_options'))
    {
      wp_die( __('You do not have sufficient permissions to access this page.') );
    }
	
	$learndash_2checkout_settings = get_option( 'learndash_2checkout_settings' );
	$learndash_2checkout_settings_sid = !empty($learndash_2checkout_settings['sid'])?  $learndash_2checkout_settings['sid']:"";
	$learndash_2checkout_settings_secret_word = !empty($learndash_2checkout_settings['secret_word'])?  $learndash_2checkout_settings['secret_word']:"";
	$learndash_2checkout_settings_demo = !empty($learndash_2checkout_settings['demo'])?  $learndash_2checkout_settings['demo']:"";
	$x_receipt_link_url = site_url( '/' ) . '?learndash-checkout=2co';
	
	
	if( isset($_POST[ "update_LearnDash2CheckoutSettings" ]) ) {
		$learndash_2checkout_settings_sid = $_POST['learndash_2checkout_settings_sid'];
		$learndash_2checkout_settings_secret_word = $_POST['learndash_2checkout_settings_secret_word'];
		$learndash_2checkout_settings_demo = empty($_POST['learndash_2checkout_settings_demo'])? 0:1;
		$learndash_2checkout_settings['sid'] = $learndash_2checkout_settings_sid;
		$learndash_2checkout_settings['secret_word'] = $learndash_2checkout_settings_secret_word;
		$learndash_2checkout_settings['demo'] = $learndash_2checkout_settings_demo;
	
		update_option( 'learndash_2checkout_settings', $learndash_2checkout_settings );
		?>
		<div class="updated"><p><strong><?php _e('settings saved.', 'learndash_2checkout' ); ?></strong></p></div>
		<?php
	}
	
	
	?>
	<div class=wrap>
	<form method="post" action="<?php echo $_SERVER["REQUEST_URI"]; ?>">
	<h2><?php echo __("LearnDash - 2Checkout Payment Gateway Settings", "learndash_2checkout"); ?></h2>
	<br>
	<h3><?php echo __("2CO Account # (SID):", "learndash_2checkout"); ?></h3>
	<input name="learndash_2checkout_settings_sid" style="min-width:30%" value="<?php echo   _e(apply_filters('format_to_edit',$learndash_2checkout_settings_sid), 'learndash_2checkout') ?>" />
	<p class="description"><?php _e( 'Your 2Checkout account number.', 'learndash_2checkout' ); ?></p>
	<br>
	<h3><?php echo __("2CO Account Secret Word:", "learndash_2checkout"); ?></h3>
	<input name="learndash_2checkout_settings_secret_word" style="min-width:30%" value="<?php echo _e(apply_filters( 'format_to_edit', $learndash_2checkout_settings_secret_word ), 'learndash_2checkout') ?>" />
	<p class="description"><?php _e( 'Must match with the secret word setting in your 2Checkout account. Located under Account > Site Management > Checkout Options.', 'learndash_2checkout' ); ?></p>
	<br>
	<h3><?php echo __( '2Checkout Approved URL', 'learndash_2checkout' ) ?></h3>
	<input type="text" style="min-width:30%" value="<?php echo esc_attr( $x_receipt_link_url ); ?>" disabled="disabled">
	<p class="description"><?php _e( 'Enter this URL into approved URL setting in your 2Checkout account. Located under Account > Site Management > Checkout Options.', 'learndash_2checkout' ); ?></p>
	<br>
	<h3><input name="learndash_2checkout_settings_demo" type="checkbox" style="min-width:0%" <?php if(!empty($learndash_2checkout_settings_demo)) echo 'CHECKED'; ?> /> Demo Mode</h3>
	<p class="description"><?php _e( 'Check to enable demo mode.', 'learndash_2checkout' ); ?></p>
	<div class="submit">
	<input type="submit" name="update_LearnDash2CheckoutSettings" value="<?php _e('Update Settings', 'learndash_2checkout') ?>" /></div>
	</form>
	<?php
}

function learndash_payment_button_2checkout($button, $params = null) {
	$learndash_2checkout_settings = get_option( 'learndash_2checkout_settings' );
	$sid = !empty($learndash_2checkout_settings['sid'])?  $learndash_2checkout_settings['sid']:"";
	$demo = !empty($learndash_2checkout_settings['demo'])?  "Y":"N";
	
	if(empty($learndash_2checkout_settings) || empty($sid) || empty($params) || empty($params['price']) || empty($params['post']) || empty($params['post']->ID))
		return $button;

	$price = number_format($params['price'],2, ".", "");
	$post =  $params['post'];
	$title = $post->post_title;
	$productid = $post->ID;
	$order_id = time().'-'.rand(100, 999);

	$action_url = $demo == 'N' ? 'https://www.2checkout.com/checkout/purchase' : 'https://sandbox.2checkout.com/checkout/purchase';
	$x_receipt_link_url = site_url( '/' ) . '?learndash-checkout=2co';
	
	$current_user = wp_get_current_user();
	$user_id = empty($current_user->ID)? 0:$current_user->ID;
	$price_type = learndash_get_setting( $productid, 'course_price_type' );
	$recurring_cycle_number = get_post_meta( $productid, 'course_price_billing_p3', true );
	$recurring_cycle = get_post_meta( $productid, 'course_price_billing_t3', true );

	switch ( $recurring_cycle ) {
		case 'D':
			$recurring_cycle_period = 'Day';
			break;
		
		case 'W':
			$recurring_cycle_period = 'Week';
			break;

		case 'M':
			$recurring_cycle_period = 'Month';
			break;

		case 'Y':
			$recurring_cycle_period = 'Year';
			break;

		default:
			$recurring_cycle_period = 'Day';
			break;
	}

	$recurrence = $price_type == 'subscribe' ? '<input type="hidden" name="li_0_recurrence" value="' . $recurring_cycle_number . ' ' . $recurring_cycle_period . '" >' : '';

	$checkout = '<div class="learndash_checkout_button learndash_2checkout_button">
		<form action="' . $action_url . '" method="post">
			<input type="hidden" name="sid" value="' . $sid . '" >
			<input type="hidden" name="mode" value="2CO" >
			<input type="hidden" name="li_0_type" value="product" >
			<input type="hidden" name="li_0_name" value="' . $title . '" >
			' . $recurrence . '
			<input type="hidden" name="li_0_product_id" value="' . $productid . '" >
			<input type="hidden" name="li_0_price" value="' . $price . '" >
			<input type="hidden" name="li_0_quantity" value="1" >
			<input type="hidden" name="li_0_tangible" value="N" >
			<input type="hidden" name="demo" value="' . $demo . '" >
			<input type="hidden" name="merchant_order_id" value="Order ID: ' . $order_id . '" >
			<input type="hidden" name="user_id" value="' . $user_id . '" >
			<input type="hidden" name="course_id" value="' . $productid . '" >
			<input type="hidden" name="x_receipt_link_url" value="' . $x_receipt_link_url . '" >
			<input type="submit" value="2Checkout"/>
		</form>
	</div>';

	return $button . $checkout;
}

?>
