<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudSearch;

class AppsDynamiteSharedJustificationPerson extends \Google\Model
{
  /**
   * @var bool
   */
  public $isRecipient;
  protected $userType = UserId::class;
  protected $userDataType = '';
  public $user;

  /**
   * @param bool
   */
  public function setIsRecipient($isRecipient)
  {
    $this->isRecipient = $isRecipient;
  }
  /**
   * @return bool
   */
  public function getIsRecipient()
  {
    return $this->isRecipient;
  }
  /**
   * @param UserId
   */
  public function setUser(UserId $user)
  {
    $this->user = $user;
  }
  /**
   * @return UserId
   */
  public function getUser()
  {
    return $this->user;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AppsDynamiteSharedJustificationPerson::class, 'Google_Service_CloudSearch_AppsDynamiteSharedJustificationPerson');
