<?php
/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Custom_Learndash
 * @subpackage Custom_Learndash/public
 * @author     Wbcom Designs <admin@wbcomdesigns.com>
 */
class Ld_Dashboard_Register_Group_Fields {
	public function __construct() {
		if ( function_exists( 'acf_add_local_field_group' ) ) :
			$group_label  = LearnDash_Custom_Label::get_label( 'group' );
			$access_modes = array(
				'free'      => esc_html__( 'Free', 'ld-dashboard' ),
				'paynow'    => esc_html__( 'Buy Now', 'ld-dashboard' ),
				'subscribe' => esc_html__( 'Recurring', 'ld-dashboard' ),
				'closed'    => esc_html__( 'Closed', 'ld-dashboard' ),
			);
			$fields       = array(
				array(
					'key'               => 'field_62de3052aeacc',
					'label'             => esc_html__( 'Group Title', 'ld-dashboard' ),
					'name'              => 'ldd_post_title',
					'type'              => 'text',
					'instructions'      => '',
					'required'          => 1,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-post-data-tab',
						'id'    => '',
					),
					'default_value'     => '',
					'placeholder'       => '',
					'prepend'           => '',
					'append'            => '',
					'maxlength'         => '',
				),
				array(
					'key'               => 'field_62de32ceaeacd',
					'label'             => esc_html__( 'Group Content', 'ld-dashboard' ),
					'name'              => 'ldd_post_content',
					'type'              => 'wysiwyg',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-post-data-tab',
						'id'    => '',
					),
					'default_value'     => '',
					'tabs'              => 'all',
					'toolbar'           => 'full',
					'media_upload'      => 1,
				),
				array(
					'key'               => 'field_62de3306aeace',
					'label'             => esc_html__( 'Group Content', 'ld-dashboard' ),
					'name'              => 'groups_group_disable_content_table_cld',
					'type'              => 'radio',
					'instructions'      => esc_html__( 'Choose whether to display the Group content table to ALL users or only enrollees', 'ld-dashboard' ),
					'required'          => 0,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-post-data-tab',
						'id'    => '',
					),
					'choices'           => array(
						''   => esc_html__( 'Always visible', 'ld-dashboard' ),
						'on' => esc_html__( 'Only visible to enrollees', 'ld-dashboard' ),
					),
					'allow_null'        => 0,
					'other_choice'      => 0,
					'default_value'     => '',
					'layout'            => 'horizontal',
					'return_format'     => 'value',
					'save_other_choice' => 0,
				),
				array(
					'key'                         => 'field_622ggwer21359e',
					'label'                       => $group_label . esc_html__( ' Materials', 'ld-dashboard' ),
					'name'                        => 'groups_group_materials_enabled_cld',
					'type'                        => 'true_false',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 1,
					'message'                     => sprintf( esc_html__( 'Any content added below is displayed on the main %s page', 'ld-dashboard' ), strtolower( $group_label ) ),
					'default_value'               => 0,
					'ui'                          => 0,
					'ui_on_text'                  => '',
					'ui_off_text'                 => '',
				),
				array(
					'key'                         => 'field_11ffr35kju4llmrsg',
					'label'                       => esc_html__( 'Materials', 'ld-dashboard' ),
					'name'                        => 'groups_group_materials_cld',
					'type'                        => 'wysiwyg',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_622ggwer21359e',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-sub-form custom-learndash-course-form',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 1,
					'readonly'                    => 0,
					'default_value'               => '',
					'tabs'                        => 'all',
					'toolbar'                     => 'full',
					'media_upload'                => 1,
					'delay'                       => 0,
				),
				array(
					'key'                         => 'field_65mkliy0hdvdgdbgdgd5a0',
					'label'                       => $group_label . esc_html__( ' Certificate', 'ld-dashboard' ),
					'name'                        => 'groups_certificate_cld',
					'type'                        => 'post_object',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 1,
					'post_type'                   => array(
						0 => 'sfwd-certificates',
					),
					'taxonomy'                    => '',
					'allow_null'                  => 0,
					'multiple'                    => 0,
					'return_format'               => 'id',
					'ui'                          => 1,
				),
				array(
					'key'               => 'field_62de352eaeacf',
					'label'             => esc_html__( 'Custom Pagination', 'ld-dashboard' ),
					'name'              => 'groups_group_courses_per_page_enabled_cld',
					'type'              => 'true_false',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-post-data-tab',
						'id'    => '',
					),
					'message'           => 'Customize the pagination options for this group content table.',
					'default_value'     => 0,
					'ui'                => 0,
					'ui_on_text'        => '',
					'ui_off_text'       => '',
				),
				array(
					'key'               => 'field_62de37ebaead0',
					'label'             => esc_html__( 'Courses', 'ld-dashboard' ),
					'name'              => 'groups_group_courses_per_page_custom_cld',
					'type'              => 'number',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_62de352eaeacf',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-post-data-tab',
						'id'    => '',
					),
					'default_value'     => '',
					'placeholder'       => '',
					'prepend'           => '',
					'append'            => 'per page',
					'min'               => '',
					'max'               => '',
					'step'              => '',
				),
				array(
					'key'               => 'field_62de382caead1',
					'label'             => esc_html__( 'Custom Course Order', 'ld-dashboard' ),
					'name'              => 'groups_group_courses_order_enabled_cld',
					'type'              => 'true_false',
					'instructions'      => esc_html__( 'Customize the display order of courses.', 'ld-dashboard' ),
					'required'          => 0,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => '',
						'id'    => '',
					),
					'message'           => '',
					'default_value'     => 0,
					'ui'                => 0,
					'ui_on_text'        => '',
					'ui_off_text'       => '',
				),
				array(
					'key'               => 'field_62de3862aead2',
					'label'             => esc_html__( 'Sort By', 'ld-dashboard' ),
					'name'              => 'groups_group_courses_orderby_cld',
					'type'              => 'select',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_62de382caead1',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => '',
						'id'    => '',
					),
					'choices'           => array(
						'title'      => esc_html__( 'Title', 'ld-dashboard' ),
						'date'       => esc_html__( 'Date', 'ld-dashboard' ),
						'menu_order' => esc_html__( 'Menu Order', 'ld-dashboard' ),
					),
					'default_value'     => false,
					'allow_null'        => 0,
					'multiple'          => 0,
					'ui'                => 0,
					'return_format'     => 'value',
					'ajax'              => 0,
					'placeholder'       => '',
				),
				array(
					'key'               => 'field_62de3912aead3',
					'label'             => esc_html__( 'Order Direction', 'ld-dashboard' ),
					'name'              => 'groups_group_courses_order_cld',
					'type'              => 'select',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_62de382caead1',
								'operator' => '==',
								'value'    => '1',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => '',
						'id'    => '',
					),
					'choices'           => array(
						'ASC'  => esc_html__( 'Ascending', 'ld-dashboard' ),
						'DESC' => esc_html__( 'Descending', 'ld-dashboard' ),
					),
					'default_value'     => false,
					'allow_null'        => 0,
					'multiple'          => 0,
					'ui'                => 0,
					'return_format'     => 'value',
					'ajax'              => 0,
					'placeholder'       => '',
				),
				array(
					'key'                         => 'field_61b6323aa055t5',
					'label'                       => esc_html__( 'Access Mode', 'ld-dashboard' ),
					'name'                        => 'groups_group_price_type_cld',
					'type'                        => 'select',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'choices'                     => $access_modes,
					'default_value'               => false,
					'allow_null'                  => 0,
					'multiple'                    => 0,
					'ui'                          => 0,
					'return_format'               => 'value',
					'ajax'                        => 0,
					'placeholder'                 => '',
				),
				array(
					'key'                         => 'field_yuyu65tgtg58',
					'label'                       => $group_label . esc_html__( ' Price', 'ld-dashboard' ),
					'name'                        => 'groups_group_price_cld',
					'type'                        => 'text',
					'instructions'                => sprintf( esc_html__( 'The %1$s is protected via the LearnDash built-in PayPal and/or Stripe. Users need to purchase the %2$s (one-time fee) in order to gain access.', 'ld-dashboard' ), strtolower( $group_label ), strtolower( $group_label ) ),
					'required'                    => 0,
					'conditional_logic'           => array(
						array(
							array(
								'field'    => 'field_61b6323aa055t5',
								'operator' => '==',
								'value'    => 'paynow',
							),
						),
						array(
							array(
								'field'    => 'field_61b6323aa055t5',
								'operator' => '==',
								'value'    => 'subscribe',
							),
						),
						array(
							array(
								'field'    => 'field_61b6323aa055t5',
								'operator' => '==',
								'value'    => 'closed',
							),
						),
					),
					'wrapper'                     => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab custom-learndash-course-sub-form',
						'id'    => '',
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'readonly'                    => 0,
					'default_value'               => '',
					'placeholder'                 => '',
					'prepend'                     => '',
					'append'                      => '',
					'maxlength'                   => '',
				),
				array(
					'key'               => 'field_poiuyt33cde',
					'label'             => esc_html__( 'Billing Cycle', 'ld-dashboard' ),
					'name'              => 'courses_course_billing_cycle_cld',
					'type'              => 'group',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_61b6323aa055t5',
								'operator' => '==',
								'value'    => 'subscribe',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab custom-learndash-course-sub-form ld-dashboard-group-field ld-dashboard-billing-cycle-field',
						'id'    => '',
					),
					'layout'            => 'row',
				),
				array(
					'key'               => 'field_tyu5667fechjy',
					'label'             => esc_html__( 'Billing Cycle Number', 'ld-dashboard' ),
					'name'              => 'groups_group_price_billing_p3_cld',
					'type'              => 'number',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_61b6323aa055t5',
								'operator' => '==',
								'value'    => 'subscribe',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab custom-learndash-course-sub-form ld-dashboard-group-field-single ldd-hide-label',
						'id'    => '',
					),
					'default_value'     => '',
					'placeholder'       => '0',
					'prepend'           => '',
					'append'            => '',
					'min'               => '',
					'max'               => '',
					'step'              => '',
				),
				array(
					'key'               => 'field_lkjhgf345fv',
					'label'             => esc_html__( 'Billing Cycle Type', 'ld-dashboard' ),
					'name'              => 'groups_group_price_billing_t3_cld',
					'type'              => 'select',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_61b6323aa055t5',
								'operator' => '==',
								'value'    => 'subscribe',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab custom-learndash-course-sub-form ld-dashboard-group-field-single ldd-hide-label',
						'id'    => '',
					),
					'choices'           => array(
						'D' => esc_html__( 'day (s)', 'ld-dashboard' ),
						'W' => esc_html__( 'week (s)', 'ld-dashboard' ),
						'M' => esc_html__( 'month (s)', 'ld-dashboard' ),
						'Y' => esc_html__( 'year (s)', 'ld-dashboard' ),
					),
					'default_value'     => false,
					'allow_null'        => 0,
					'multiple'          => 0,
					'ui'                => 0,
					'return_format'     => 'value',
					'ajax'              => 0,
					'placeholder'       => '',
				),
				array(
					'key'               => 'field_mqdfnuf646f',
					'label'             => esc_html__( 'Recurring Times', 'ld-dashboard' ),
					'name'              => 'groups_post_no_of_cycles_cld',
					'type'              => 'number',
					'instructions'      => esc_html__( 'How many times the billing cycle repeats. Leave empty for unlimited repeats', 'ld-dashboard' ),
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_61b6323aa055t5',
								'operator' => '==',
								'value'    => 'subscribe',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab custom-learndash-course-sub-form',
						'id'    => '',
					),
					'default_value'     => '',
					'placeholder'       => '',
					'prepend'           => '',
					'append'            => '',
					'min'               => '',
					'max'               => '',
					'step'              => '',
				),
				array(
					'key'               => 'field_qaqa0909olujg',
					'label'             => $group_label . esc_html__( ' Trial Price', 'ld-dashboard' ),
					'name'              => 'groups_group_trial_price_cld',
					'type'              => 'number',
					'instructions'      => esc_html__( 'Enter the price for the trial period for this Course', 'ld-dashboard' ),
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_61b6323aa055t5',
								'operator' => '==',
								'value'    => 'subscribe',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab custom-learndash-course-sub-form',
						'id'    => '',
					),
					'default_value'     => '',
					'placeholder'       => '',
					'prepend'           => '',
					'append'            => '',
					'min'               => '',
					'max'               => '',
					'step'              => '',
				),

				array(
					'key'               => 'field_123lkh23cvbn3',
					'label'             => esc_html__( 'Trial Duration', 'ld-dashboard' ),
					'name'              => 'courses_course_billing_cycle_cld',
					'type'              => 'text',
					'instructions'      => sprintf( esc_html__( 'The length of the trial period, after the trial is over, the normal %s price billing goes into effect.', 'ld-dashboard' ), $group_label ),
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_61b6323aa055t5',
								'operator' => '==',
								'value'    => 'subscribe',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab custom-learndash-course-sub-form ld-dashboard-group-field ld-dashboard-trial-duration-field',
						'id'    => '',
					),
					'layout'            => 'row',
				),
				array(
					'key'               => 'field_gfhfy54sahghdr4',
					'label'             => esc_html__( 'Trial Duration Number', 'ld-dashboard' ),
					'name'              => 'groups_group_trial_duration_p1_cld',
					'type'              => 'number',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_61b6323aa055t5',
								'operator' => '==',
								'value'    => 'subscribe',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab custom-learndash-course-sub-form ld-dashboard-group-field-single ldd-hide-label',
						'id'    => '',
					),
					'default_value'     => '',
					'placeholder'       => '0',
					'prepend'           => '',
					'append'            => '',
					'min'               => '',
					'max'               => '',
					'step'              => '',
				),
				array(
					'key'               => 'field_kiy67fdd44gg',
					'label'             => esc_html__( 'Trial Duration Type', 'ld-dashboard' ),
					'name'              => 'groups_group_trial_duration_t1_cld',
					'type'              => 'select',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_61b6323aa055t5',
								'operator' => '==',
								'value'    => 'subscribe',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab custom-learndash-course-sub-form ld-dashboard-group-field-single ldd-hide-label',
						'id'    => '',
					),
					'choices'           => array(
						'D' => esc_html__( 'day (s)', 'ld-dashboard' ),
						'W' => esc_html__( 'week (s)', 'ld-dashboard' ),
						'M' => esc_html__( 'month (s)', 'ld-dashboard' ),
						'Y' => esc_html__( 'year (s)', 'ld-dashboard' ),
					),
					'default_value'     => false,
					'allow_null'        => 0,
					'multiple'          => 0,
					'ui'                => 0,
					'return_format'     => 'value',
					'ajax'              => 0,
					'placeholder'       => '',
				),
				array(
					'key'               => 'field_113gfff21mml',
					'label'             => esc_html__( 'Button URL', 'ld-dashboard' ),
					'name'              => 'groups_custom_button_url_cld',
					'type'              => 'url',
					'instructions'      => esc_html__( 'Redirect the "Take this Course" button to a specific URL.', 'ld-dashboard' ),
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_61b6323aa055t5',
								'operator' => '==',
								'value'    => 'closed',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab custom-learndash-course-sub-form',
						'id'    => '',
					),
					'default_value'     => '',
					'placeholder'       => '',
				),
				array(
					'key'               => 'field_aaf7c332tyih',
					'label'             => $group_label . esc_html__( ' Enrollment URL', 'ld-dashboard' ),
					'name'              => 'groups_group_price_type_subscribe_enrollment_url_cld',
					'type'              => 'url',
					'instructions'      => sprintf( esc_html__( 'Enter the URL of the page you want to redirect your enrollees after signing up for this specific %s', 'ld-dashboard' ), $group_label ),
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_61b6323aa055t5',
								'operator' => '==',
								'value'    => 'subscribe',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab custom-learndash-course-sub-form',
						'id'    => '',
					),
					'default_value'     => '',
					'placeholder'       => '',
				),
				array(
					'key'               => 'field_11wer231ddfr',
					'label'             => $group_label . esc_html__( ' Enrollment URL', 'ld-dashboard' ),
					'name'              => 'groups_group_price_type_paynow_enrollment_url_cld',
					'type'              => 'url',
					'instructions'      => sprintf( esc_html__( 'Enter the URL of the page you want to redirect your enrollees after signing up for this specific %s', 'ld-dashboard' ), $group_label ),
					'required'          => 0,
					'conditional_logic' => array(
						array(
							array(
								'field'    => 'field_61b6323aa055t5',
								'operator' => '==',
								'value'    => 'paynow',
							),
						),
					),
					'wrapper'           => array(
						'width' => '',
						'class' => 'custom-learndash-course-form ld-dashboard-form-settings-data-tab custom-learndash-course-sub-form',
						'id'    => '',
					),
					'default_value'     => '',
					'placeholder'       => '',
				),
				array(
					'key'               => 'field_62de3af0aead4',
					'label'             => esc_html__( 'Group Courses', 'ld-dashboard' ),
					'name'              => 'group_courses_cld',
					'type'              => 'post_object',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => '',
						'id'    => '',
					),
					'post_type'         => array(
						0 => 'sfwd-courses',
					),
					'taxonomy'          => '',
					'allow_null'        => 0,
					'multiple'          => 1,
					'return_format'     => 'id',
					'ui'                => 1,
				),
				array(
					'key'               => 'field_62de3cd0aead5',
					'label'             => esc_html__( 'Group Users', 'ld-dashboard' ),
					'name'              => 'group_users_cld',
					'type'              => 'user',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => '',
						'id'    => '',
					),
					'role'              => '',
					'allow_null'        => 0,
					'multiple'          => 1,
					'return_format'     => 'id',
				),
				array(
					'key'               => 'field_62de3d0faead6',
					'label'             => esc_html__( 'Group Leaders', 'ld-dashboard' ),
					'name'              => 'group_leaders_cld',
					'type'              => 'user',
					'instructions'      => '',
					'required'          => 0,
					'conditional_logic' => 0,
					'wrapper'           => array(
						'width' => '',
						'class' => '',
						'id'    => '',
					),
					'role'              => array(
						0 => 'group_leader',
					),
					'allow_null'        => 0,
					'multiple'          => 1,
					'return_format'     => 'id',
				),
			);

			// Add/Edit question form fields for frontend.
			$fields = apply_filters( 'ld_dashboard_group_form_fields', $fields );

			// Register question form fields for frontend.
			acf_add_local_field_group(
				array(
					'key'                   => 'group-field-group',
					'title'                 => 'Group',
					'fields'                => $fields,
					'location'              => array(
						array(
							array(
								'param'    => 'page',
								'operator' => '==',
								'value'    => Ld_Dashboard_Functions::instance()->ld_dashboard_get_page_id( 'dashboard' ),
							),
							array(
								'param'    => 'current_user',
								'operator' => '==',
								'value'    => 'viewing_front',
							),
						),
					),
					'menu_order'            => 0,
					'position'              => 'normal',
					'style'                 => 'default',
					'label_placement'       => 'top',
					'instruction_placement' => 'label',
					'hide_on_screen'        => '',
					'active'                => true,
					'description'           => '',
				)
			);

			endif;
	}
}
