<?php
/*
Plugin Name: Custom LearnDash CSS
Plugin URI: https://blueprintcoders.com/learndashcss
description: A plugin to add custom CSS to LearnDash. Access/edit the CSS file in "/wp-content/plugins/learndash-custom-css/css/custom-learndash-css.css"
Version: 1.1
Author: Blueprint Coding
Author URI: http://blueprintcoders.com
License:     GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/
defined( 'ABSPATH' ) or die( 'Feeling lucky punk?' );

/* Do Nothing Function */
function relax() {
    ;
}


/* Check if LearnDash is installed and active */


function check_ld_active() {


    if (class_exists('SFWD_LMS')) {
        // Plugin is active
        //Add Custom CSS file
        add_action('wp_enqueue_scripts', 'callback_for_setting_up_scripts');
        //Add Admin Panel and CSS
        add_action('admin_menu', 'ldcss_plugin_setup_menu');
        add_action('admin_enqueue_scripts', 'ln_reg_css_and_js');
    } else {
        echo
        "<div display='none'>
    <script type='text/javascript'>
        console.log('LearnDash Plugin Is Not Detected, Custom CSS Plugin Not Loaded');
    </script>
</div>";
        relax();
    }
}

add_action('init', 'check_ld_active');


/* Add CSS To LearnDash Pages */

function callback_for_setting_up_scripts() {


    /* Get Custom Labels from LearnDash */
    $course_slug = LearnDash_Custom_Label::get_label( 'course' );
    $courses_slug = LearnDash_Custom_Label::get_label( 'courses' );
    $lesson_slug = LearnDash_Custom_Label::get_label( 'lesson' );
    $lessons_slug = LearnDash_Custom_Label::get_label( 'lessons' );
    $topic_slug = LearnDash_Custom_Label::get_label( 'topic' );
    $topics_slug = LearnDash_Custom_Label::get_label( 'topics' );
    $quiz_slug = LearnDash_Custom_Label::get_label( 'quiz' );
    $quizs_slug = LearnDash_Custom_Label::get_label( 'quiz' );
    /* Load Custom Labels from LearnDash into array and make lower case */
    $LDlabels = [$course_slug,$courses_slug, $lesson_slug, $lessons_slug,$topic_slug,$topics_slug,$quiz_slug,$quizs_slug];
    $LDlabelsLC = array_map('strtolower', $LDlabels);

    /* Functin to get URI and search to see if it's in the array */
    function in_URI(array $array)
    {
        // Please review the code entirely.
        foreach($array AS $key => $value){
            // If the URI does contain one of the words in the array
            if (strpos($_SERVER['REQUEST_URI'], $value) !== FALSE) {

                // Return that it has been found
                return true;
            }
        }
        // Return that the values have not been found
        return false;
    }

    if(in_URI($LDlabelsLC)){
        /* If Label matches URI load CSS into page */
        $site = get_site_url();
        $cssLoc =$site."/wp-content/plugins/learndash-custom-css/css/custom-learndash-css.css";
        wp_register_style( 'namespace', $cssLoc );
        wp_enqueue_style( 'namespace' );
        wp_enqueue_script( 'namespaceformyscript', $cssLoc, array( 'jquery' ) );
        echo
        "<div display='none'>
    <script type='text/javascript'>
        console.log('LearnDash Page Detected, Loading Custom CSS');
    </script>
</div>";

    }else{
        /* If Label does not match URI do nothing */
        echo
        "<div display='none'>
    <script type='text/javascript'>
        console.log('No LearnDash Page Detected, Custom CSS Not Loaded');
    </script>
</div>";
        relax();
    }
   }



function ldcss_plugin_setup_menu(){
    add_menu_page( 'Custom LearnDash CSS Plugin Page', 'Custom LD CSS', 'manage_options', 'custom-ld-css-plugin', 'ldcssadmin_init','dashicons-art');
}



/* Hooks in admin panel CSS */

function ln_reg_css_and_js($hook)
{
    $current_screen = get_current_screen();
    if ( strpos($current_screen->base, 'custom-ld-css-plugin') === false) {
        return;
    } else {
        wp_enqueue_style('boot_css', plugins_url('admin/cldcss-admin.css',__FILE__ ));
    }
}

/* Admin Panel Content */
function ldcssadmin_init(){
    $site = get_site_url();
    $imgLoc =$site."/wp-content/plugins/learndash-custom-css/images/customLearnDashCSSBanner.jpg";
    $imgLoc2 =$site."/wp-content/plugins/learndash-custom-css/images/BPCAd.jpg";
    echo "<div class=\"wrap ldadminp\"><img src ='".$imgLoc."'>";
    echo "<h1>Welcome to the Custom LearnDash CSS Plugin</h1>";
    echo "<p><a target='_blank' href='http://blueprintcoders.com'>by Blueprint Coding | blueprintcoders.com</a></p>";
    echo "<p>This plugin adds a custom css file to LearnDash pages only so you can add styles that may override the rest of your site's css without breaking non-LearnDash pages.</p>";
    echo "<p>The CSS file is located in '/wp-content/plugins/learndash-custom-css/css/'. The CSS file name is: 'custom-learndash-css.css'</p>";
    echo "<p>It identifies the LearnDash page by matching the URL (ex: http://mysite.com/course/my-course) to LearnDash labels (ex: course). If you use custom LearnDash labels it will recognize that and match them.";
    echo "<p><strong>How do I tell if the plugin is loading properly?</strong><br> Go to one of your LearnDash course/lesson/topic pages and inspect element. Then check the console. If you will see 'LearnDash Page Detected, Loading Custom CSS' if it is loading properly. On non-LearnDash pages you should see 'No LearnDash Page Detected, Custom CSS Not Loaded'.</p>";
    echo "<p>For bug reports, feedback or support email: <a href='mailto:blueprintcoders@gmail.com'>blueprintcoders@gmail.com</a></p>";
    echo "<hr>";
    cssEditor();
    echo "</div>";
    echo "<a href='http://blueprintcoders.com' target='_blank'><img class='BCPad' src='".$imgLoc2."'></a>";

}

/* Links user to the wordpress plugin editor directly with the CSS file open */
function cssEditor (){
    $site = get_site_url();
    $cssLoc =$site."/wp-admin/plugin-editor.php?file=learndash-custom-css%2Fcss%2Fcustom-learndash-css.css&plugin=learndash-custom-css%2Fcustom-learndash-css.php";
echo "<div class='buttonHolder'>";
echo "<a class='editCssButton' target='_blank' href='".$cssLoc."'>Click here to edit CSS file via default WP plugin editor</a>";
echo "<p>NOTE: Be careful not to edit any other files than the 'custom-learndash-css.css' file as it can break your plugins. Alternatively use a FTP client or file manager to navigate to the file and edit it in your preferred IDE.</p>";
echo "</div>";
}


?>